/*
 * Decompiled with CFR 0.152.
 */
package physica.library.client.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import physica.api.core.inventory.IPlayerUsing;
import physica.library.client.render.TessellatorWrapper;
import physica.library.inventory.slot.IRenderableSlot;
import physica.library.inventory.tooltip.IToolTipContainer;
import physica.library.inventory.tooltip.ToolTip;

@SideOnly(value=Side.CLIENT)
public class GuiContainerBase<T extends IPlayerUsing>
extends GuiContainer {
    public static final ResourceLocation GUI_COMPONENTS = new ResourceLocation("physica", "textures/gui/gui_components.png");
    public static final ResourceLocation GUI_BASE = new ResourceLocation("physica", "textures/gui/gui_base.png");
    public static final int defaultYSize = 166;
    protected Set<ToolTip> tooltips = new HashSet<ToolTip>();
    protected Set<GuiTextField> fields = new HashSet<GuiTextField>();
    protected int meterHeight = 49;
    protected int meterWidth = 14;
    protected int electricityMeterHeight = 11;
    protected int electricityMeterWidth = 107;
    protected int containerWidth;
    protected int containerHeight;
    protected T host;

    public GuiContainerBase(Container container, T host) {
        super(container);
        this.host = host;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.fields.clear();
        this.tooltips.clear();
        this.field_147002_h.field_75151_b.stream().forEach(s -> {
            ToolTip toolTip;
            if (s instanceof IToolTipContainer && (toolTip = ((IToolTipContainer)s).getToolTip()) != null) {
                this.tooltips.add(toolTip);
            }
        });
    }

    protected <E extends GuiButton> E addButton(E button) {
        this.field_146292_n.add(button);
        return button;
    }

    protected void addToolTip(int x, int y, int w, int h, String text) {
        this.addToolTip(new Rectangle(x, y, w, h), text);
    }

    protected void addToolTip(Rectangle triggerArea, String text) {
        this.addToolTip(new ToolTip(triggerArea, text));
    }

    protected void addToolTip(ToolTip toolTip) {
        this.tooltips.add(toolTip);
    }

    protected void drawString(String str, int x, int y, int color) {
        this.field_146289_q.func_78276_b(str, x, y, color);
    }

    protected void drawString(String str, int x, int y) {
        this.drawString(str, x, y, 0x404040);
    }

    protected void drawString(String str, int x, int y, Color color) {
        this.drawString(str, x, y, color.getRGB());
    }

    protected void drawStringCentered(String str, int x, int y) {
        this.drawStringCentered(str, x, y, 0x404040);
    }

    protected void drawStringCentered(String str, int x, int y, Color color) {
        this.drawStringCentered(str, x, y, color.getRGB());
    }

    protected void drawStringCentered(String str, int x, int y, int color) {
        this.drawString(str, x - this.field_146289_q.func_78256_a(str) / 2, y, color);
    }

    protected GuiTextField newField(int x, int y, int w, String msg) {
        return this.newInputField(x, y, w, 20, msg);
    }

    protected GuiTextField newInputField(int x, int y, int w, int h, String msg) {
        GuiTextField textField = new GuiTextField(this.field_146289_q, x, y, w, h);
        textField.func_146180_a("" + msg);
        textField.func_146203_f(15);
        textField.func_146193_g(0xFFFFFF);
        this.fields.add(textField);
        return textField;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
    }

    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
        if (this.fields != null && this.fields.size() > 0) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3042);
            for (GuiTextField field : this.fields) {
                field.func_146194_f();
            }
        }
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        ToolTip fetched = null;
        for (ToolTip toolTip : this.tooltips) {
            if (!toolTip.shouldShowAt(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
            fetched = toolTip;
            break;
        }
        if (fetched != null && fetched.shouldShow()) {
            this.drawTooltip(mouseX, mouseY, fetched.getLocalizedTooltip().split(";"));
        }
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    protected void func_73869_a(char c, int id) {
        boolean f = false;
        for (GuiTextField field : this.fields) {
            field.func_146201_a(c, id);
            if (!field.func_146206_l()) continue;
            return;
        }
        if (!f) {
            super.func_73869_a(c, id);
        }
    }

    protected void func_73864_a(int p_73864_1_, int p_73864_2_, int p_73864_3_) {
        super.func_73864_a(p_73864_1_, p_73864_2_, p_73864_3_);
        for (GuiTextField field : this.fields) {
            field.func_146192_a(p_73864_1_, p_73864_2_, p_73864_3_);
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        this.containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(GUI_BASE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float scale = (float)this.field_147000_g / 166.0f;
        GL11.glScalef((float)1.0f, (float)scale, (float)1.0f);
        this.func_73729_b(this.containerWidth, (int)((float)this.containerHeight / scale), 0, 0, this.field_146999_f, this.field_147000_g);
        GL11.glScalef((float)1.0f, (float)(1.0f / scale), (float)1.0f);
        this.preDrawContainerSlots();
        this.drawContainerSlots();
    }

    protected void preDrawContainerSlots() {
    }

    protected void drawContainerSlots() {
        for (Object object : this.field_147002_h.field_75151_b) {
            this.drawSlot((Slot)object);
        }
    }

    protected void drawSlot(Slot slot) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (slot instanceof IRenderableSlot) {
            ((IRenderableSlot)slot).renderSlotOverlay((Gui)this, this.containerWidth + slot.field_75223_e - 1, this.containerHeight + slot.field_75221_f - 1);
        } else {
            this.drawSlot(slot.field_75223_e - 1, slot.field_75221_f - 1);
        }
    }

    protected void drawSlot(int x, int y) {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 0, 18, 18);
    }

    public void drawLargeBar(int x, int y, int w, float percent, Color color) {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        int width = Math.round(percent * 138.0f);
        this.setColor(null);
        this.drawRectWithScaledWidth(this.containerWidth + x, this.containerHeight + y, 54, 33, 140, 15, w);
        this.setColor(color);
        this.drawRectWithScaledWidth(this.containerWidth + x + 1, this.containerHeight + y + 1, 55, 65, width, 13, w - 2);
    }

    public void drawSmallBar(int x, int y, int w, float percent, Color color) {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        int width = Math.round(percent * 105.0f);
        this.setColor(null);
        this.drawRectWithScaledWidth(this.containerWidth + x, this.containerHeight + y, 54, 0, 107, 11, w);
        this.setColor(color);
        this.drawRectWithScaledWidth(this.containerWidth + x + 1, this.containerHeight + y + 1, 55, 24, width, 9, w);
    }

    public void drawMicroBar(int x, int y, float percent, Color color) {
        this.drawMicroBar(x, y, -1, percent, color);
    }

    public void drawMicroBar(int x, int y, int w, float percent, Color color) {
        int backgroundWidth = 56;
        int fillBarWidth = 54;
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        this.setColor(null);
        this.drawRectWithScaledWidth(this.containerWidth + x, this.containerHeight + y, 54, 79, 56, 7, w);
        int width = Math.round(percent * 54.0f);
        this.setColor(color);
        this.drawRectWithScaledWidth(this.containerWidth + x + 1, this.containerHeight + y + 1, 55, 87, width, 5, (int)((float)(w - 2) * percent));
    }

    protected void drawRectWithScaledWidth(int x, int y, int u, int v, int width, int height, int newWidth) {
        if (width > 0) {
            if (newWidth <= 0 || width == newWidth) {
                this.func_73729_b(x, y, u, v, width, height);
            }
            int midWidth = width - 6;
            this.func_73729_b(x, y, u, v, 3, height);
            x += 3;
            if (newWidth > 6) {
                int loops;
                for (loops = newWidth / width; loops > 0; --loops) {
                    this.func_73729_b(x, y, u + 3, v, midWidth, height);
                    x += midWidth;
                }
                loops = newWidth % width;
                if (loops != 0) {
                    this.func_73729_b(x, y, u + 3, v, loops, height);
                    x += loops;
                }
            }
            if (width > 3) {
                this.func_73729_b(x, y, u + width - 3, v, 3, height);
            }
        }
    }

    protected void setColor(Color color) {
        if (color == null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        }
    }

    protected void drawElectricity(int x, int y, float scale) {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 0, this.electricityMeterWidth, this.electricityMeterHeight);
        if (scale > 0.0f) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 22, (int)(scale * (float)this.electricityMeterWidth), this.electricityMeterHeight);
        }
    }

    protected void drawFluidTank(int x, int y, IFluidTank tank) {
        this.drawFluidTank(x, y, tank, null);
    }

    protected void drawFluidTank(int x, int y, IFluidTank tank, Color edgeColor) {
        float scale = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        FluidStack fluidStack = tank.getFluid();
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (edgeColor != null) {
            GL11.glColor4f((float)((float)edgeColor.getRed() / 255.0f), (float)((float)edgeColor.getGreen() / 255.0f), (float)((float)edgeColor.getBlue() / 255.0f), (float)((float)edgeColor.getAlpha() / 255.0f));
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 0, this.meterWidth, this.meterHeight);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.containerWidth + x + 1, this.containerHeight + y + 1, 41, 1, this.meterWidth - 2, this.meterHeight - 2);
        } else {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 0, this.meterWidth, this.meterHeight);
        }
        if (fluidStack != null) {
            this.drawFluid(this.containerWidth + x, this.containerHeight + y, -10, 1, 12, (int)((float)(this.meterHeight - 1) * scale), fluidStack);
        }
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 98, this.meterWidth, this.meterHeight);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawTooltip(int x, int y, String ... tooltips) {
        this.drawTooltip(x, y, Lists.newArrayList((Object[])tooltips));
    }

    public void drawTooltip(int x, int y, List<String> tooltips) {
        this.drawHoveringText(tooltips, x, y, this.field_146289_q);
    }

    protected void drawFluid(int x, int y, int line, int col, int width, int drawSize, FluidStack fluidStack) {
        Fluid fluid;
        if (fluidStack != null && (fluid = fluidStack.getFluid()) != null) {
            --drawSize;
            IIcon fluidIcon = null;
            if (fluid.getStillIcon() != null) {
                fluidIcon = fluid.getStillIcon();
            }
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(FMLClientHandler.instance().getClient().field_71446_o.func_130087_a(fluid.getSpriteNumber()));
            int textureSize = 16;
            int start = 0;
            if (fluidIcon != null) {
                int renderY = textureSize;
                while (renderY != 0 && drawSize != 0) {
                    if (drawSize > textureSize) {
                        renderY = textureSize;
                        drawSize -= textureSize;
                    } else {
                        renderY = drawSize;
                        drawSize = 0;
                    }
                    this.func_94065_a(x + col, y + line + 58 - renderY - start, fluidIcon, width, textureSize - (textureSize - renderY));
                    start += textureSize;
                }
            }
        }
    }

    public void func_94065_a(int x, int y, IIcon icon, int width, int height) {
        TessellatorWrapper tessellator = TessellatorWrapper.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0, y + height, this.field_73735_i, icon.func_94209_e(), icon.func_94210_h());
        tessellator.addVertexWithUV(x + width, y + height, this.field_73735_i, icon.func_94212_f(), icon.func_94210_h());
        tessellator.addVertexWithUV(x + width, y + 0, this.field_73735_i, icon.func_94212_f(), icon.func_94206_g());
        tessellator.addVertexWithUV(x + 0, y + 0, this.field_73735_i, icon.func_94209_e(), icon.func_94206_g());
        tessellator.draw();
    }

    protected void renderFurnaceCookArrow(int x, int y, float progress) {
        this.renderFurnaceCookArrow(x, y, progress, 1.0);
    }

    protected void renderFurnaceCookArrow(int x, int y, double cookTime, double maxCookTime) {
        cookTime = Math.min(cookTime, maxCookTime);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 18, 0, 22, 15);
        if (cookTime > 0.0) {
            double progress = cookTime / maxCookTime;
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 18, 15, (int)Math.floor(22.0 * progress), 15);
        }
    }
}

