/*
 * Decompiled with CFR 0.152.
 */
package physica.library.client.render;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import physica.api.core.tile.ITileBase;
import physica.library.client.render.TessellatorWrapper;
import physica.library.client.render.obj.PhysicaModelLoader;
import physica.library.client.render.obj.model.WavefrontObject;

public class TileRenderObjModel<T extends ITileBase>
extends TileEntitySpecialRenderer {
    protected WavefrontObject wavefrontObject;
    protected ResourceLocation resourceTexture;

    public TileRenderObjModel(String objFile, String textureFile, String domain, String modelDirectory, String modelTextureDirectory) {
        this.wavefrontObject = PhysicaModelLoader.loadWavefrontModel(new ResourceLocation(domain, modelDirectory + objFile));
        this.resourceTexture = new ResourceLocation(domain, modelTextureDirectory + textureFile);
    }

    public static void renderFloatingText(String text, float x, float y, float z, int color) {
        RenderManager renderManager = RenderManager.field_78727_a;
        FontRenderer fontRenderer = renderManager.func_78716_a();
        float scale = 0.027f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glTranslatef((float)(x + 0.0f), (float)(y + 2.3f), (float)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        TessellatorWrapper tessellator = TessellatorWrapper.instance;
        int yOffset = 0;
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        int stringMiddle = fontRenderer.func_78256_a(text) / 2;
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.5f);
        tessellator.addVertex(-stringMiddle - 1, -1 + yOffset, 0.0);
        tessellator.addVertex(-stringMiddle - 1, 8 + yOffset, 0.0);
        tessellator.addVertex(stringMiddle + 1, 8 + yOffset, 0.0);
        tessellator.addVertex(stringMiddle + 1, -1 + yOffset, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        fontRenderer.func_78276_b(text, -fontRenderer.func_78256_a(text) / 2, yOffset, color);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontRenderer.func_78276_b(text, -fontRenderer.func_78256_a(text) / 2, yOffset, color);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderTileAt(T tile, double x, double y, double z, float deltaFrame) {
        GL11.glEnable((int)32826);
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glScaled((double)0.0625, (double)0.0625, (double)0.0625);
        switch (tile.getFacing()) {
            case NORTH: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        this.func_147499_a(this.resourceTexture);
        this.wavefrontObject.render();
        switch (tile.getFacing()) {
            case NORTH: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        GL11.glScaled((double)16.0, (double)16.0, (double)16.0);
        GL11.glTranslated((double)(-(x + 0.5)), (double)(-(y + 0.5)), (double)(-(z + 0.5)));
    }

    public final void func_147500_a(TileEntity tile, double x, double y, double z, float deltaFrame) {
        this.renderTileAt((ITileBase)tile, x, y, z, deltaFrame);
    }
}

