/*
 * Decompiled with CFR 0.152.
 */
package physica.library.energy;

import physica.api.core.utilities.IBaseUtilities;
import physica.library.energy.base.Measurement;
import physica.library.energy.base.Unit;

public class ElectricityDisplay
implements IBaseUtilities {
    public static String getDisplay(double value, Unit unit, int decimalPlaces, boolean isShort) {
        String unitName = unit.name;
        double testValue = value;
        if (testValue < 10.0) {
            testValue = value / 1000.0;
        }
        if (isShort) {
            unitName = unit.symbol;
        } else if (testValue > 1.0) {
            unitName = unit.getPlural();
        }
        if (value == 0.0) {
            return value + " " + unitName;
        }
        if (testValue < 1.0) {
            return IBaseUtilities.roundPreciseStatic(Measurement.MILLI.process(value), decimalPlaces) + " " + Measurement.MILLI.getName(isShort) + unitName;
        }
        if (testValue > Measurement.GIGA.value) {
            return IBaseUtilities.roundPreciseStatic(Measurement.GIGA.process(value), decimalPlaces) + " " + Measurement.GIGA.getName(isShort) + unitName;
        }
        if (testValue > Measurement.MEGA.value) {
            return IBaseUtilities.roundPreciseStatic(Measurement.MEGA.process(value), decimalPlaces) + " " + Measurement.MEGA.getName(isShort) + unitName;
        }
        if (testValue > Measurement.KILO.value) {
            return IBaseUtilities.roundPreciseStatic(Measurement.KILO.process(value), decimalPlaces) + " " + Measurement.KILO.getName(isShort) + unitName;
        }
        return IBaseUtilities.roundPreciseStatic(value, decimalPlaces) + " " + unitName;
    }

    public static String getDisplay(double value, Unit unit) {
        return ElectricityDisplay.getDisplay(value, unit, 2, false);
    }

    public static String getDisplayShort(double value, Unit unit) {
        return ElectricityDisplay.getDisplay(value, unit, 2, true);
    }

    public static String getDisplayShort(double value, Unit unit, int decimalPlaces) {
        return ElectricityDisplay.getDisplay(value, unit, decimalPlaces, true);
    }

    public static String getDisplaySimple(double value, Unit unit, int decimalPlaces) {
        if (value > 1.0) {
            if (decimalPlaces < 1) {
                return (int)value + " " + unit.getPlural();
            }
            return IBaseUtilities.roundPreciseStatic(value, decimalPlaces) + " " + unit.getPlural();
        }
        if (decimalPlaces < 1) {
            return (int)value + " " + unit.name;
        }
        return IBaseUtilities.roundPreciseStatic(value, decimalPlaces) + " " + unit.name;
    }

    public static String getDisplayShortTicked(double value, Unit unit) {
        return ElectricityDisplay.getDisplayShort(value, unit) + "/t";
    }
}

