/*
 * Decompiled with CFR 0.152.
 */
package physica.library.energy.base;

public enum Measurement {
    MILLI("\u041c\u0438\u043b\u043b\u0438", "m", 0.001),
    KILO("\u041a\u0438\u043b\u043e", "k", 1000.0),
    MEGA("\u041c\u0435\u0433\u0430", "M", 1000000.0),
    GIGA("\u0413\u0438\u0433\u0430", "G", 1.0E9);

    public String name;
    public String symbol;
    public double value;

    private Measurement(String name, String symbol, double value) {
        this.name = name;
        this.symbol = symbol;
        this.value = value;
    }

    public String getName(boolean isSymbol) {
        if (isSymbol) {
            return this.symbol;
        }
        return this.name;
    }

    public int integerValue() {
        return (int)this.value;
    }

    public double process(double value) {
        return value / this.value;
    }
}

