/*
 * Decompiled with CFR 0.152.
 */
package physica.library.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import physica.api.core.electricity.IElectricItem;
import physica.library.energy.ElectricityDisplay;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;

public class ItemElectric
extends Item
implements IElectricItem {
    public static final String ENERGY_NBT_DATA = "Energy";
    protected int capacity;
    protected int receiveRate;
    protected int extractRate;

    public ItemElectric() {
    }

    public ItemElectric(int capacity) {
        this(capacity, capacity, capacity);
    }

    public ItemElectric(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public ItemElectric(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.receiveRate = maxReceive;
        this.extractRate = maxExtract;
        this.setNoRepair();
        this.func_77656_e(100);
        this.func_77625_d(1);
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack disCharged = new ItemStack((Item)this);
        this.setEnergyStored(disCharged, 0);
        list.add(disCharged);
        ItemStack charged = new ItemStack((Item)this);
        this.setEnergyStored(charged, this.capacity);
        list.add(charged);
    }

    public double getDurabilityForDisplay(ItemStack container) {
        return 1.0 - (double)this.getElectricityStored(container) / (double)this.getElectricCapacity(container);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getElectricityStored(stack) < this.getElectricCapacity(stack) && this.getElectricityStored(stack) > 0;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean par4) {
        super.func_77624_a(stack, player, info, par4);
        info.add(EnumChatFormatting.AQUA + "\u0425\u0440\u0430\u043d\u0438\u0442\u0441\u044f \u044d\u043d\u0435\u0440\u0433\u0438\u0438: " + EnumChatFormatting.GRAY + ElectricityDisplay.getDisplayShort(ElectricityUtilities.convertEnergy((double)this.getElectricityStored(stack), Unit.RF, Unit.WATTHOUR), Unit.WATTHOUR));
    }

    @Override
    public int extractElectricity(ItemStack container, int amount, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b(ENERGY_NBT_DATA)) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e(ENERGY_NBT_DATA);
        int energyExtracted = Math.min(energy, Math.min(this.extractRate, amount));
        if (!simulate) {
            this.setEnergyStored(container, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getElectricCapacity(ItemStack container) {
        return this.capacity;
    }

    @Override
    public int receiveElectricity(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e(ENERGY_NBT_DATA);
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.receiveRate, maxReceive));
        if (!simulate) {
            this.setEnergyStored(container, energy += energyReceived);
        }
        return energyReceived;
    }

    public ItemElectric setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public void setExtractRate(int extractRate) {
        this.extractRate = extractRate;
    }

    public void setReceiveRate(int receiveRate) {
        this.receiveRate = receiveRate;
    }

    public void setMaxTransfer(int maxTransfer) {
        this.setExtractRate(maxTransfer);
        this.setReceiveRate(maxTransfer);
    }
}

