/*
 * Decompiled with CFR 0.152.
 */
package physica.library.location;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import physica.api.core.abstraction.Face;
import physica.library.location.VectorLocation;

public class GridLocation {
    public int xCoord;
    public int yCoord;
    public int zCoord;

    public GridLocation() {
        this(0, 0, 0);
    }

    public GridLocation(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public GridLocation(TileEntity tile) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public static GridLocation Sub(GridLocation a, GridLocation b) {
        return new GridLocation(a.xCoord - b.xCoord, a.yCoord - b.yCoord, a.zCoord - b.zCoord);
    }

    public static GridLocation Add(GridLocation a, GridLocation b) {
        return new GridLocation(a.xCoord + b.xCoord, a.yCoord + b.yCoord, a.zCoord + b.zCoord);
    }

    public static GridLocation Mul(GridLocation a, int f) {
        return new GridLocation(a.xCoord * f, a.yCoord * f, a.zCoord * f);
    }

    public static GridLocation Abs(GridLocation a) {
        return new GridLocation(Math.abs(a.xCoord), Math.abs(a.yCoord), Math.abs(a.zCoord));
    }

    public GridLocation set(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        return this;
    }

    public GridLocation set(GridLocation location) {
        return this.set(location.xCoord, location.yCoord, location.zCoord);
    }

    public int getX() {
        return this.xCoord;
    }

    public int getY() {
        return this.yCoord;
    }

    public int getZ() {
        return this.zCoord;
    }

    public float norm() {
        return (float)Math.sqrt(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord);
    }

    public VectorLocation normalize() {
        float n = this.norm();
        return new VectorLocation((float)this.xCoord / n, (float)this.yCoord / n, (float)this.zCoord / n);
    }

    public GridLocation OffsetFace(Face direction) {
        return new GridLocation(this.xCoord + direction.offsetX, this.yCoord + direction.offsetY, this.zCoord + direction.offsetZ);
    }

    public float getDistance(float x2, float y2, float z2) {
        double d3 = (float)this.xCoord - x2;
        double d4 = (float)this.yCoord - y2;
        double d5 = (float)this.zCoord - z2;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public float getDistance(double x2, double y2, double z2) {
        double d3 = (double)this.xCoord - x2;
        double d4 = (double)this.yCoord - y2;
        double d5 = (double)this.zCoord - z2;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public double getDistanceSquared(double x2, double y2, double z2) {
        double d3 = (double)this.xCoord - x2;
        double d4 = (double)this.yCoord - y2;
        double d5 = (double)this.zCoord - z2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public float getDistance(VectorLocation vector) {
        double d3 = (double)this.xCoord - vector.x;
        double d4 = (double)this.yCoord - vector.y;
        double d5 = (double)this.zCoord - vector.z;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public float getDistance(GridLocation vector) {
        double d3 = this.xCoord - vector.xCoord;
        double d4 = this.yCoord - vector.yCoord;
        double d5 = this.zCoord - vector.zCoord;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public double getAverage() {
        return (float)(this.xCoord + this.yCoord + this.zCoord) / 3.0f;
    }

    public TileEntity getTile(IBlockAccess world) {
        return world.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
    }

    public int getMetadata(IBlockAccess world) {
        return world.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
    }

    public void setMetadata(World world, int meta) {
        world.func_72921_c(this.xCoord, this.yCoord, this.zCoord, meta, 3);
    }

    public float getHardness(World world) {
        return this.getBlock((IBlockAccess)world).func_149712_f(world, this.xCoord, this.yCoord, this.zCoord);
    }

    public Block getBlock(IBlockAccess world) {
        return world.func_147439_a(this.xCoord, this.yCoord, this.zCoord);
    }

    public void setBlock(World world, Block block) {
        world.func_147449_b(this.xCoord, this.yCoord, this.zCoord, block);
    }

    public void setBlockNonUpdate(World world, Block block) {
        world.func_147465_d(this.xCoord, this.yCoord, this.zCoord, block, 0, 2);
    }

    public void setBlockAir(World world) {
        world.func_147468_f(this.xCoord, this.yCoord, this.zCoord);
    }

    public void setBlockAirNonUpdate(World world) {
        world.func_147465_d(this.xCoord, this.yCoord, this.zCoord, Blocks.field_150350_a, 0, 2);
    }

    public void setTile(World world, TileEntity tile) {
        world.func_147455_a(this.xCoord, this.yCoord, this.zCoord, tile);
    }

    public boolean isAirBlock(IBlockAccess world) {
        return world.func_147437_c(this.xCoord, this.yCoord, this.zCoord);
    }

    public GridLocation sub(GridLocation b) {
        this.xCoord -= b.xCoord;
        this.yCoord -= b.yCoord;
        this.zCoord -= b.zCoord;
        return this;
    }

    public GridLocation sub(int sub) {
        this.xCoord -= sub;
        this.yCoord -= sub;
        this.zCoord -= sub;
        return this;
    }

    public GridLocation add(GridLocation b) {
        this.xCoord += b.xCoord;
        this.yCoord += b.yCoord;
        this.zCoord += b.zCoord;
        return this;
    }

    public GridLocation add(int add) {
        this.xCoord += add;
        this.yCoord += add;
        this.zCoord += add;
        return this;
    }

    public GridLocation mul(GridLocation b) {
        this.xCoord *= b.xCoord;
        this.yCoord *= b.yCoord;
        this.zCoord *= b.zCoord;
        return this;
    }

    public GridLocation mul(float mul) {
        this.xCoord = (int)((float)this.xCoord * mul);
        this.yCoord = (int)((float)this.yCoord * mul);
        this.zCoord = (int)((float)this.zCoord * mul);
        return this;
    }

    public GridLocation abs() {
        this.xCoord = Math.abs(this.xCoord);
        this.yCoord = Math.abs(this.yCoord);
        this.zCoord = Math.abs(this.zCoord);
        return this;
    }

    public GridLocation Copy() {
        return new GridLocation(this.xCoord, this.yCoord, this.zCoord);
    }

    public VectorLocation Vector() {
        return new VectorLocation(this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GridLocation) {
            GridLocation other = (GridLocation)obj;
            return this.xCoord == other.xCoord && this.yCoord == other.yCoord && this.zCoord == other.zCoord;
        }
        return false;
    }

    public int hashCode() {
        return 255 - this.yCoord;
    }

    public void writeToNBT(NBTTagCompound tag, String vectorName) {
        tag.func_74768_a(vectorName + "-X", this.xCoord);
        tag.func_74768_a(vectorName + "-Y", this.yCoord);
        tag.func_74768_a(vectorName + "-Z", this.zCoord);
    }

    public void readFromNBT(NBTTagCompound tag, String vectorName) {
        this.xCoord = tag.func_74762_e(vectorName + "-X");
        this.yCoord = tag.func_74762_e(vectorName + "-Y");
        this.zCoord = tag.func_74762_e(vectorName + "-Z");
    }

    public String toString() {
        return "BlockLocation [" + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + "]";
    }
}

