/*
 * Decompiled with CFR 0.152.
 */
package physica.library.location;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import physica.library.location.GridLocation;

public class VectorLocation {
    public double x;
    public double y;
    public double z;

    public VectorLocation() {
        this(0.0, 0.0, 0.0);
    }

    public VectorLocation(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public VectorLocation(Entity entity) {
        this.x = entity.field_70165_t;
        this.y = entity.field_70163_u;
        this.z = entity.field_70161_v;
    }

    public VectorLocation(TileEntity tile) {
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
    }

    public static VectorLocation Cross(VectorLocation a, VectorLocation b) {
        double x = a.y * b.z - a.z * b.y;
        double y = a.z * b.x - a.x * b.z;
        double z = a.x * b.y - a.y * b.x;
        return new VectorLocation(x, y, z);
    }

    public static VectorLocation Sub(VectorLocation a, VectorLocation b) {
        return new VectorLocation(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static VectorLocation Add(VectorLocation a, VectorLocation b) {
        return new VectorLocation(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static VectorLocation Mul(VectorLocation a, float f) {
        return new VectorLocation(a.x * (double)f, a.y * (double)f, a.z * (double)f);
    }

    public static VectorLocation Abs(VectorLocation a) {
        return new VectorLocation(Math.abs(a.x), Math.abs(a.y), Math.abs(a.z));
    }

    public static VectorLocation Floor(VectorLocation a) {
        return new VectorLocation(Math.floor(a.x), Math.floor(a.y), Math.floor(a.z));
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int floorX() {
        return (int)Math.floor(this.x);
    }

    public int floorY() {
        return (int)Math.floor(this.y);
    }

    public int floorZ() {
        return (int)Math.floor(this.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float norm() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void translate(float x, float y, float z) {
        this.x += (double)x;
        this.y += (double)y;
        this.z += (double)z;
    }

    public VectorLocation normalize() {
        float n = this.norm();
        return this.div(n);
    }

    public VectorLocation createNormalized() {
        float n = this.norm();
        return new VectorLocation(this.x / (double)n, this.y / (double)n, this.z / (double)n);
    }

    public float getDistance(float x2, float y2, float z2) {
        double d3 = this.x - (double)x2;
        double d4 = this.y - (double)y2;
        double d5 = this.z - (double)z2;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public float getDistance(VectorLocation vector) {
        double d3 = this.x - vector.x;
        double d4 = this.y - vector.y;
        double d5 = this.z - vector.z;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public float getDistance(GridLocation blockLocation) {
        double d3 = this.x - (double)blockLocation.xCoord;
        double d4 = this.y - (double)blockLocation.yCoord;
        double d5 = this.z - (double)blockLocation.zCoord;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public double getAverage() {
        return (this.x + this.y + this.z) / 3.0;
    }

    public TileEntity getTile(IBlockAccess world) {
        return world.func_147438_o(this.floorX(), this.floorY(), this.floorZ());
    }

    public int getMetadata(IBlockAccess world) {
        return world.func_72805_g(this.floorX(), this.floorY(), this.floorZ());
    }

    public void setMetadata(World world, int meta) {
        world.func_72921_c(this.floorX(), this.floorY(), this.floorZ(), meta, 3);
    }

    public float getHardness(World world) {
        return this.getBlock((IBlockAccess)world).func_149712_f(world, this.floorX(), this.floorY(), this.floorZ());
    }

    public Block getBlock(IBlockAccess world) {
        return world.func_147439_a(this.floorX(), this.floorY(), this.floorZ());
    }

    public void setBlock(World world, Block block) {
        world.func_147449_b(this.floorX(), this.floorY(), this.floorZ(), block);
    }

    public void setBlockAir(World world) {
        world.func_147468_f(this.floorX(), this.floorY(), this.floorZ());
    }

    public void setTile(World world, TileEntity tile) {
        world.func_147455_a(this.floorX(), this.floorY(), this.floorZ(), tile);
    }

    public boolean isAirBlock(IBlockAccess world) {
        return world.func_147437_c(this.floorX(), this.floorY(), this.floorZ());
    }

    public VectorLocation cross(VectorLocation b) {
        this.x = this.y * b.z - this.z * b.y;
        this.y = this.z * b.x - this.x * b.z;
        this.z = this.x * b.y - this.y * b.x;
        return this;
    }

    public VectorLocation sub(VectorLocation b) {
        this.x -= b.x;
        this.y -= b.y;
        this.z -= b.z;
        return this;
    }

    public VectorLocation sub(int sub) {
        this.x -= (double)sub;
        this.y -= (double)sub;
        this.z -= (double)sub;
        return this;
    }

    public VectorLocation add(VectorLocation b) {
        this.x += b.x;
        this.y += b.y;
        this.z += b.z;
        return this;
    }

    public VectorLocation add(int add) {
        this.x += (double)add;
        this.y += (double)add;
        this.z += (double)add;
        return this;
    }

    public VectorLocation add(double add) {
        this.x += add;
        this.y += add;
        this.z += add;
        return this;
    }

    public VectorLocation mul(VectorLocation b) {
        this.x *= b.x;
        this.y *= b.y;
        this.z *= b.z;
        return this;
    }

    public VectorLocation mul(float mul) {
        this.x *= (double)mul;
        this.y *= (double)mul;
        this.z *= (double)mul;
        return this;
    }

    public VectorLocation div(VectorLocation b) {
        this.x /= b.x;
        this.y /= b.y;
        this.z /= b.z;
        return this;
    }

    public VectorLocation div(float div) {
        this.x /= (double)div;
        this.y /= (double)div;
        this.z /= (double)div;
        return this;
    }

    public VectorLocation abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        return this;
    }

    public VectorLocation floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        return this;
    }

    public VectorLocation Copy() {
        return new VectorLocation(this.x, this.y, this.z);
    }

    public GridLocation BlockLocation() {
        return new GridLocation(this.floorX(), this.floorY(), this.floorZ());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VectorLocation other = (VectorLocation)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public void writeToNBT(NBTTagCompound tag, String vectorName) {
        tag.func_74780_a(vectorName + "-X", this.x);
        tag.func_74780_a(vectorName + "-Y", this.y);
        tag.func_74780_a(vectorName + "-Z", this.z);
    }

    public void readFromNBT(NBTTagCompound tag, String vectorName) {
        this.x = tag.func_74769_h(vectorName + "-X");
        this.y = tag.func_74769_h(vectorName + "-Y");
        this.z = tag.func_74769_h(vectorName + "-Z");
    }
}

