/*
 * Decompiled with CFR 0.152.
 */
package physica.library.net;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashSet;
import java.util.Set;
import physica.library.net.energy.ElectricNetwork;

public class ElectricNetworkRegistry {
    public static ElectricNetworkRegistry INSTANCE = new ElectricNetworkRegistry();
    private final HashSet<ElectricNetwork> networks = new HashSet();

    public static ElectricNetworkRegistry getInstance() {
        return INSTANCE;
    }

    public void registerNetwork(ElectricNetwork network) {
        this.networks.add(network);
    }

    public void removeNetwork(ElectricNetwork network) {
        this.networks.remove(network);
    }

    public void pruneEmptyNetworks() {
        for (ElectricNetwork e : this.networks) {
            if (e.conductorSet.size() != 0) continue;
            this.removeNetwork(e);
        }
    }

    @SubscribeEvent
    public void update(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Set iterNetworks = (Set)this.networks.clone();
            for (ElectricNetwork net : iterNetworks) {
                if (!this.networks.contains(net)) continue;
                net.tick();
            }
        }
    }
}

