/*
 * Decompiled with CFR 0.152.
 */
package physica.library.net.energy;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.conductor.EnumConductorType;
import physica.api.core.conductor.IConductor;
import physica.library.location.GridLocation;
import physica.library.net.ElectricNetworkRegistry;

public class ElectricNetwork {
    private static final int DEFAULT_VOLTAGE = 120;
    private final HashMap<EnumConductorType, HashSet<IConductor>> conductorTypeMap = new HashMap();
    public HashSet<IConductor> conductorSet = new HashSet();
    public HashSet<TileEntity> acceptorSet = new HashSet();
    public HashMap<TileEntity, HashSet<Face>> acceptorInputMap = new HashMap();
    private int energyTransmittedBuffer = 0;
    private int energyTransmittedLastTick = 0;
    private int fixTimerTicksSinceNetworkCreate = 0;
    private int ticksSinceNetworkRefresh = 0;
    private boolean fixed = false;
    private int maxPowerTransfer = 0;

    public ElectricNetwork(IConductor ... varCables) {
        this.conductorSet.addAll(Arrays.asList(varCables));
        ElectricNetworkRegistry.getInstance().registerNetwork(this);
    }

    public ElectricNetwork(Set<ElectricNetwork> networks) {
        for (ElectricNetwork net : networks) {
            if (net == null) continue;
            this.addAllCables(net.conductorSet);
            net.deregister();
        }
        this.refresh();
        ElectricNetworkRegistry.getInstance().registerNetwork(this);
    }

    public int getEnergyTransmittedLastTick() {
        return this.energyTransmittedLastTick;
    }

    public int getMaxPowerTransfer() {
        return this.maxPowerTransfer;
    }

    public int emit(int energyToSend, ArrayList<TileEntity> ignored) {
        if ((energyToSend = Math.min(this.maxPowerTransfer - this.energyTransmittedBuffer, energyToSend)) > 0) {
            Set<TileEntity> availableAcceptors = this.getEnergyAcceptors();
            int energySent = 0;
            if (!availableAcceptors.isEmpty()) {
                this.checkForVoltage(energyToSend);
                HashSet<TileEntity> validAcceptors = new HashSet<TileEntity>();
                for (TileEntity acceptor : availableAcceptors) {
                    if (ignored.contains(acceptor) || !AbstractionLayer.Electricity.isElectricReceiver(acceptor)) continue;
                    validAcceptors.add(acceptor);
                }
                if (validAcceptors.size() > 0) {
                    int energyPerReceiver = energyToSend / validAcceptors.size();
                    for (TileEntity receiver : validAcceptors) {
                        for (Face connection : this.acceptorInputMap.get(receiver)) {
                            energySent += AbstractionLayer.Electricity.receiveElectricity(receiver, connection.getOpposite(), energyPerReceiver, false);
                        }
                    }
                }
            }
            this.energyTransmittedBuffer += energySent;
            return energySent;
        }
        return 0;
    }

    public int getSafeVoltageLevel() {
        for (EnumConductorType index : EnumConductorType.values()) {
            if (!this.conductorTypeMap.containsKey((Object)index) || this.conductorTypeMap.get((Object)index).isEmpty()) continue;
            return index.getVoltage();
        }
        return 0;
    }

    private void checkForVoltage(int energyToSend) {
        HashSet<EnumConductorType> checkList = new HashSet<EnumConductorType>();
        for (EnumConductorType type : EnumConductorType.values()) {
            int calculatedVoltage;
            if (type.getVoltage() <= 0 || (calculatedVoltage = energyToSend / (type.getTransferRate() / 120)) <= type.getVoltage()) continue;
            checkList.add(type);
        }
        for (EnumConductorType index : checkList) {
            for (IConductor conductor : this.conductorTypeMap.get((Object)index)) {
                conductor.destroyNodeViolently();
            }
        }
    }

    public Set<TileEntity> getEnergyAcceptors() {
        HashSet<TileEntity> toReturn = new HashSet<TileEntity>();
        for (TileEntity acceptor : this.acceptorSet) {
            if (!AbstractionLayer.Electricity.isElectricReceiver(acceptor)) continue;
            for (Face connection : this.acceptorInputMap.get(acceptor)) {
                Face direction = connection.getOpposite();
                if (!AbstractionLayer.Electricity.canInputElectricityNow(acceptor, direction)) continue;
                toReturn.add(acceptor);
            }
        }
        return toReturn;
    }

    public TileEntity[] getConnectedEnergyAcceptors(TileEntity tileEntity) {
        TileEntity[] acceptors = new TileEntity[]{null, null, null, null, null, null};
        for (Face orientation : Face.VALID) {
            TileEntity acceptor = new GridLocation(tileEntity).OffsetFace(orientation).getTile((IBlockAccess)tileEntity.func_145831_w());
            if (!AbstractionLayer.Electricity.isElectricReceiver(acceptor) || acceptor instanceof IConductor) continue;
            acceptors[orientation.ordinal()] = acceptor;
        }
        return acceptors;
    }

    public void refresh() {
        Set iterCables = (Set)this.conductorSet.clone();
        Iterator it = iterCables.iterator();
        this.acceptorSet.clear();
        this.acceptorInputMap.clear();
        while (it.hasNext()) {
            IConductor conductor = (IConductor)it.next();
            if (conductor == null || ((TileEntity)conductor).func_145837_r()) {
                it.remove();
                this.conductorSet.remove(conductor);
                continue;
            }
            conductor.setNetwork(this);
        }
        for (IConductor cable : iterCables) {
            TileEntity[] acceptors;
            for (TileEntity acceptor : acceptors = this.getConnectedEnergyAcceptors((TileEntity)cable)) {
                if (acceptor == null || acceptor instanceof IConductor) continue;
                this.acceptorSet.add(acceptor);
                HashSet<Face> directions = this.acceptorInputMap.containsKey(acceptor) ? this.acceptorInputMap.get(acceptor) : new HashSet<Face>();
                directions.add(Face.getOrientation(Arrays.asList(acceptors).indexOf(acceptor)));
                this.acceptorInputMap.put(acceptor, directions);
            }
        }
        this.updatePowerRate();
    }

    private void updatePowerRate() {
        this.maxPowerTransfer = 0;
        this.conductorTypeMap.clear();
        for (EnumConductorType type : EnumConductorType.values()) {
            this.conductorTypeMap.put(type, new HashSet());
        }
        for (IConductor cable : this.conductorSet) {
            this.conductorTypeMap.get((Object)cable.getCableType()).add(cable);
            this.maxPowerTransfer += cable.getCableType().getTransferRate();
        }
    }

    public void merge(ElectricNetwork network) {
        if (network != null && network != this) {
            HashSet<ElectricNetwork> networks = new HashSet<ElectricNetwork>();
            networks.add(this);
            networks.add(network);
            ElectricNetwork newNetwork = new ElectricNetwork(networks);
            newNetwork.refresh();
        }
    }

    public void addAllCables(Set<IConductor> newCables) {
        this.conductorSet.addAll(newCables);
    }

    public void split(IConductor splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.removeCable(splitPoint);
            TileEntity[] connectedBlocks = new TileEntity[6];
            boolean[] dealtWith = new boolean[]{false, false, false, false, false, false};
            for (Face direction : Face.VALID) {
                TileEntity sideTile = new GridLocation((TileEntity)splitPoint).OffsetFace(direction).getTile((IBlockAccess)((TileEntity)splitPoint).func_145831_w());
                if (sideTile == null) continue;
                connectedBlocks[Arrays.asList(Face.values()).indexOf((Object)((Object)direction))] = sideTile;
            }
            for (int countOne = 0; countOne < connectedBlocks.length; ++countOne) {
                TileEntity connectedBlockA = connectedBlocks[countOne];
                if (!(connectedBlockA instanceof IConductor) || dealtWith[countOne]) continue;
                NetworkFinder finder = new NetworkFinder(((TileEntity)splitPoint).func_145831_w(), new GridLocation(connectedBlockA), new GridLocation((TileEntity)splitPoint));
                List<GridLocation> partNetwork = finder.exploreNetwork();
                for (int countTwo = countOne + 1; countTwo < connectedBlocks.length; ++countTwo) {
                    TileEntity connectedBlockB = connectedBlocks[countTwo];
                    if (!(connectedBlockB instanceof IConductor) || dealtWith[countTwo] || !partNetwork.contains(new GridLocation(connectedBlockB))) continue;
                    dealtWith[countTwo] = true;
                }
                ElectricNetwork newNetwork = new ElectricNetwork(new IConductor[0]);
                for (GridLocation node : finder.iterated) {
                    TileEntity nodeTile = node.getTile((IBlockAccess)((TileEntity)splitPoint).func_145831_w());
                    if (!(nodeTile instanceof IConductor) || nodeTile == splitPoint) continue;
                    newNetwork.conductorSet.add((IConductor)nodeTile);
                }
                newNetwork.refresh();
            }
            this.deregister();
        }
    }

    public void fixMessedUpNetwork(IConductor cable) {
        if (cable instanceof TileEntity) {
            NetworkFinder finder = new NetworkFinder(((TileEntity)cable).func_145831_w(), new GridLocation((TileEntity)cable), new GridLocation[0]);
            List<GridLocation> partNetwork = finder.exploreNetwork();
            HashSet<IConductor> newCables = new HashSet<IConductor>();
            for (GridLocation node : partNetwork) {
                TileEntity nodeTile = node.getTile((IBlockAccess)((TileEntity)cable).func_145831_w());
                if (!(nodeTile instanceof IConductor)) continue;
                ((IConductor)nodeTile).removeFromNetwork();
                newCables.add((IConductor)nodeTile);
            }
            ElectricNetwork newNetwork = new ElectricNetwork(newCables.toArray(new IConductor[0]));
            newNetwork.refresh();
            newNetwork.fixed = true;
            this.deregister();
        }
    }

    public void removeCable(IConductor cable) {
        this.conductorSet.remove(cable);
        if (this.conductorSet.size() == 0) {
            this.deregister();
        }
    }

    public void deregister() {
        this.conductorSet.clear();
        ElectricNetworkRegistry.getInstance().removeNetwork(this);
    }

    public void tick() {
        this.clearJoulesTransmitted();
        if (!this.fixed) {
            ++this.fixTimerTicksSinceNetworkCreate;
            if (this.fixTimerTicksSinceNetworkCreate > 1200) {
                this.fixTimerTicksSinceNetworkCreate = 0;
                this.fixMessedUpNetwork(this.conductorSet.toArray(new IConductor[0])[0]);
            }
        }
        ++this.ticksSinceNetworkRefresh;
        if (this.ticksSinceNetworkRefresh > 1600) {
            this.ticksSinceNetworkRefresh = 0;
            this.refresh();
        }
    }

    public void clearJoulesTransmitted() {
        this.energyTransmittedLastTick = this.energyTransmittedBuffer;
        this.energyTransmittedBuffer = 0;
    }

    public static class NetworkLoader {
        @SubscribeEvent
        public void onChunkLoad(ChunkEvent.Load event) {
            if (event.getChunk() != null) {
                for (Object obj : event.getChunk().field_150816_i.values()) {
                    TileEntity tileEntity;
                    if (!(obj instanceof TileEntity) || !((tileEntity = (TileEntity)obj) instanceof IConductor)) continue;
                    ((IConductor)tileEntity).refreshNetwork();
                }
            }
        }
    }

    public static class NetworkFinder {
        public World worldObj;
        public GridLocation start;
        public List<GridLocation> iterated = new ArrayList<GridLocation>();
        public List<GridLocation> toIgnore = new ArrayList<GridLocation>();

        public NetworkFinder(World world, GridLocation location, GridLocation ... ignore) {
            this.worldObj = world;
            this.start = location;
            if (ignore.length > 0) {
                this.toIgnore = Arrays.asList(ignore);
            }
        }

        public void loopAll(GridLocation location) {
            if (location.getTile((IBlockAccess)this.worldObj) instanceof IConductor) {
                this.iterated.add(location);
            }
            for (Face direction : Face.VALID) {
                TileEntity tileEntity;
                GridLocation obj = location.OffsetFace(direction);
                if (this.iterated.contains(obj) || this.toIgnore.contains(obj) || !((tileEntity = obj.getTile((IBlockAccess)this.worldObj)) instanceof IConductor)) continue;
                this.loopAll(obj);
            }
        }

        public List<GridLocation> exploreNetwork() {
            this.loopAll(this.start);
            return this.iterated;
        }
    }
}

