/*
 * Decompiled with CFR 0.152.
 */
package physica.library.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidTank;
import physica.library.network.IPacket;

public class PacketBase
implements IPacket {
    protected Set<Object> writeData = new HashSet<Object>();
    protected ByteBuf readData;

    public <P extends IPacket> P addData(Object ... data) {
        for (Object object : data) {
            this.writeData.add(object);
        }
        return (P)this;
    }

    @Override
    public void decodeInto(ChannelHandlerContext handler, ByteBuf buffer) {
        this.readData = buffer.slice().copy();
    }

    @Override
    public void encodeInto(ChannelHandlerContext handler, ByteBuf buffer) {
        for (Object object : this.writeData) {
            this.writeData(object, buffer);
        }
    }

    public ByteBuf getReadData() {
        return this.readData;
    }

    protected void writeData(Object object, ByteBuf buffer) {
        if (object.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                this.writeData(Array.get(object, i), buffer);
            }
        } else if (object instanceof Collection) {
            for (Object o : (Collection)object) {
                this.writeData(o, buffer);
            }
        } else if (object instanceof Byte) {
            buffer.writeByte((int)((Byte)object).byteValue());
        } else if (object instanceof Boolean) {
            buffer.writeBoolean(((Boolean)object).booleanValue());
        } else if (object instanceof Enum) {
            buffer.writeInt(((Enum)object).ordinal());
        } else if (object instanceof Integer) {
            buffer.writeInt(((Integer)object).intValue());
        } else if (object instanceof Short) {
            buffer.writeShort((int)((Short)object).shortValue());
        } else if (object instanceof Long) {
            buffer.writeLong(((Long)object).longValue());
        } else if (object instanceof Float) {
            buffer.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            buffer.writeDouble(((Double)object).doubleValue());
        } else if (object instanceof String) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((String)object));
        } else if (object instanceof NBTTagCompound) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((NBTTagCompound)object));
        } else if (object instanceof ItemStack) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)((ItemStack)object));
        } else if (object instanceof FluidTank) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((FluidTank)object).writeToNBT(new NBTTagCompound()));
        } else {
            throw new IllegalArgumentException("PacketBase: Unsupported write method for " + object.getClass().getSimpleName());
        }
    }
}

