/*
 * Decompiled with CFR 0.152.
 */
package physica.library.network.netty;

import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import physica.api.core.PhysicaAPI;
import physica.library.network.IPacket;
import physica.library.network.packet.PacketTile;

public class PacketEncoderDecoderHandler
extends FMLIndexedMessageToMessageCodec<IPacket> {
    public boolean silenceStackTrace = false;
    private int nextID = 0;

    public PacketEncoderDecoderHandler() {
        this.addPacket(PacketTile.class);
    }

    public void addPacket(Class<? extends IPacket> clazz) {
        this.addDiscriminator(this.nextID++, clazz);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, IPacket packet) {
        try {
            packet.decodeInto(ctx, source);
        }
        catch (Exception e) {
            if (!this.silenceStackTrace) {
                PhysicaAPI.logger.error("Failed to decode packet " + packet, (Throwable)e);
            }
            PhysicaAPI.logger.error("Failed to decode packet " + packet + " Exception: " + e.getMessage());
        }
    }

    public void encodeInto(ChannelHandlerContext ctx, IPacket packet, ByteBuf target) throws Exception {
        try {
            packet.encodeInto(ctx, target);
        }
        catch (Exception e) {
            if (!this.silenceStackTrace) {
                PhysicaAPI.logger.error("Failed to encode packet " + packet, (Throwable)e);
            }
            PhysicaAPI.logger.error("Failed to encode packet " + packet + " Exception: " + e.getMessage());
        }
    }
}

