/*
 * Decompiled with CFR 0.152.
 */
package physica.library.network.netty;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import physica.api.core.PhysicaAPI;
import physica.api.core.load.IContent;
import physica.api.core.load.LoadPhase;
import physica.library.location.GridLocation;
import physica.library.network.IPacket;
import physica.library.network.netty.PacketChannelInboundHandler;
import physica.library.network.netty.PacketEncoderDecoderHandler;

public class PacketSystem
implements IContent {
    public static PacketSystem INSTANCE = new PacketSystem("physicapacketsystem");
    public final String channel;
    protected EnumMap<Side, FMLEmbeddedChannel> channelEnumMap;

    public PacketSystem(String channel) {
        this.channel = channel;
    }

    @Override
    public void register(LoadPhase phase) {
        if (phase == LoadPhase.Initialize) {
            this.channelEnumMap = NetworkRegistry.INSTANCE.newChannel(this.channel, new ChannelHandler[]{new PacketEncoderDecoderHandler(), new PacketChannelInboundHandler()});
        }
    }

    public void sendToAll(IPacket packet) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
        } else {
            PhysicaAPI.logger.error("Packet sent to all");
        }
    }

    public void sendToAllAround(IPacket message, NetworkRegistry.TargetPoint point) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)message);
        } else {
            PhysicaAPI.logger.error("Packet sent to target point: " + point);
        }
    }

    public void sendToAllAround(IPacket message, TileEntity tile) {
        this.sendToAllAround(message, tile, 64.0);
    }

    public void sendToAllAround(IPacket message, TileEntity tile, double range) {
        this.sendToAllAround(message, tile.func_145831_w(), new GridLocation(tile), range);
    }

    public void sendToAllAround(IPacket message, World world, GridLocation loc, double range) {
        if (world != null) {
            this.sendToAllAround(message, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)loc.xCoord, (double)loc.yCoord, (double)loc.zCoord, range));
        }
    }

    public void sendToAllInDimension(IPacket packet, int dimId) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimId);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
        } else {
            PhysicaAPI.logger.error("Packet sent to dim[" + dimId + "]");
        }
    }

    public void sendToAllInDimension(IPacket packet, World world) {
        this.sendToAllInDimension(packet, world.field_73011_w.field_76574_g);
    }

    public void sendToPlayer(IPacket packet, EntityPlayerMP player) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
        } else {
            PhysicaAPI.logger.error("Packet sent to player[" + player + "]");
        }
    }

    public void sendToServer(IPacket packet) {
        if (this.channelEnumMap != null) {
            if (this.channelEnumMap.get(Side.CLIENT) != null) {
                this.channelEnumMap.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
                this.channelEnumMap.get(Side.CLIENT).writeAndFlush((Object)packet);
            } else {
                PhysicaAPI.logger.error("PacketManager#sendToServer(packet): Attempted to fire client to server packet on server, this is not allowed. Packet = " + packet);
            }
        } else {
            PhysicaAPI.logger.error("PacketManager#sendToServer(packet): Channel enum map is empty, can't send packet. Packet = " + packet);
        }
    }

    public Packet toMCPacket(IPacket packet) {
        return this.channelEnumMap.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
    }
}

