/*
 * Decompiled with CFR 0.152.
 */
package physica.library.network.packet;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import physica.api.core.PhysicaAPI;
import physica.library.network.IPacketReciever;
import physica.library.network.PacketBase;

public class PacketTile
extends PacketBase {
    public int x;
    public int y;
    public int z;
    public int id;
    public int customInteger;
    public String name;

    public PacketTile() {
    }

    public PacketTile(String name, int id, int x, int y, int z) {
        this.name = name;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketTile(String name, int id, int x, int y, int z, int customInteger) {
        this.name = name;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.customInteger = customInteger;
    }

    public PacketTile(String name, int id, TileEntity tile) {
        this(name, id, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.id = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.customInteger = buffer.readInt();
        super.decodeInto(ctx, buffer);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.customInteger);
        super.encodeInto(ctx, buffer);
    }

    public void handle(EntityPlayer player) {
        if (player.func_130014_f_() == null && PhysicaAPI.isDebugMode) {
            PhysicaAPI.logger.error("PacketTile#handle(" + player.getDisplayName() + ") - world is null for player while handling packet. ", (Throwable)new NullPointerException());
            return;
        }
        if (player.func_130014_f_().func_72899_e(this.x, this.y, this.z)) {
            this.handle(player, player.func_130014_f_().func_147438_o(this.x, this.y, this.z));
        } else if (PhysicaAPI.isDebugMode) {
            PhysicaAPI.logger.error("PacketTile#handle(" + player.getDisplayName() + ") - block is not loaded for player while handling packet. ");
        }
    }

    public void handle(EntityPlayer player, TileEntity tile) {
        block15: {
            if (tile == null) {
                if (PhysicaAPI.isDebugMode && FMLCommonHandler.instance().getSide().isServer()) {
                    PhysicaAPI.logger.error((Object)new RuntimeException("PacketTile#handle(" + player.getDisplayName() + ", null) - Null tile"));
                }
            } else if (tile.func_145837_r()) {
                if (PhysicaAPI.isDebugMode && FMLCommonHandler.instance().getSide().isServer()) {
                    PhysicaAPI.logger.error((Object)new RuntimeException("PacketTile#handle(" + player.getDisplayName() + ", TILE[" + tile.func_145831_w().func_72912_H().func_76065_j() + ": " + tile.field_145851_c + ", " + tile.field_145848_d + ", " + tile.field_145849_e + "]) - Invalidated tile"));
                }
            } else {
                if (tile instanceof IPacketReciever) {
                    try {
                        IPacketReciever receiver = (IPacketReciever)tile;
                        receiver.read(this.readData, this.id, player, this);
                    }
                    catch (IndexOutOfBoundsException e) {
                        if (PhysicaAPI.isDebugMode) {
                            PhysicaAPI.logger.error((Object)new RuntimeException("PacketTile#handle(" + player.getDisplayName() + ", TILE[" + tile.func_145831_w().func_72912_H().func_76065_j() + ": " + tile.field_145851_c + ", " + tile.field_145848_d + ", " + tile.field_145849_e + "Packet was read past it's size."));
                            PhysicaAPI.logger.error("Error: ", (Throwable)e);
                        }
                        break block15;
                    }
                    catch (NullPointerException e) {
                        if (PhysicaAPI.isDebugMode) {
                            PhysicaAPI.logger.error((Object)new RuntimeException("PacketTile#handle(" + player.getDisplayName() + ", TILE[" + tile.func_145831_w().func_72912_H().func_76065_j() + ": " + tile.field_145851_c + ", " + tile.field_145848_d + ", " + tile.field_145849_e + "Null pointer while reading data", e));
                            PhysicaAPI.logger.error("Error: ", (Throwable)e);
                        }
                        break block15;
                    }
                    catch (Exception e) {
                        if (PhysicaAPI.isDebugMode) {
                            PhysicaAPI.logger.error((Object)new RuntimeException("PacketTile#handle(" + player.getDisplayName() + ", TILE[" + tile.func_145831_w().func_72912_H().func_76065_j() + ": " + tile.field_145851_c + ", " + tile.field_145848_d + ", " + tile.field_145849_e + "Failed to read packet", e));
                            PhysicaAPI.logger.error("Error: ", (Throwable)e);
                        }
                        break block15;
                    }
                }
                if (PhysicaAPI.isDebugMode) {
                    PhysicaAPI.logger.error("Error: " + tile + " rejected packet " + this + " due to invalid conditions.");
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        if (player != null) {
            this.handle(player);
        } else if (PhysicaAPI.isDebugMode) {
            PhysicaAPI.logger.error("PacketTile#handleClientSide(null) - player was null for packet", (Throwable)new NullPointerException());
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (player != null) {
            this.handle(player);
        } else if (PhysicaAPI.isDebugMode) {
            PhysicaAPI.logger.error("PacketTile#handleServerSide(null) - player was null for packet", (Throwable)new NullPointerException());
        }
    }
}

