/*
 * Decompiled with CFR 0.152.
 */
package physica.library.recipe;

import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import physica.library.recipe.RecipeSystemTemplate;
import physica.library.util.OreDictionaryUtilities;

public class RecipeSystem {
    private static final HashMap<Object, HashSet<RecipeSystemTemplate>> recipeMap = new HashMap();

    public static HashMap<Object, HashSet<RecipeSystemTemplate>> getRecipemap() {
        return recipeMap;
    }

    public static <T extends RecipeSystemTemplate> void registerRecipe(Object handle, T recipe2) {
        if (!recipeMap.containsKey(handle)) {
            recipeMap.put(handle, new HashSet());
        }
        recipeMap.get(handle).add(recipe2);
    }

    public static <T extends RecipeSystemTemplate> void unregisterRecipe(Object handle, T recipe2) {
        if (recipeMap.containsKey(handle)) {
            recipeMap.get(handle).remove(recipe2);
        }
    }

    public static <T extends RecipeSystemTemplate> HashSet<T> getHandleRecipes(Object handle) {
        if (!recipeMap.containsKey(handle)) {
            recipeMap.put(handle, new HashSet());
        }
        return recipeMap.get(handle);
    }

    public static <T extends RecipeSystemTemplate> T getRecipe(Object handle, ItemStack input) {
        if (input != null) {
            for (RecipeSystemTemplate recipe2 : RecipeSystem.getHandleRecipes(handle)) {
                if ((recipe2.getInput() == null || !recipe2.getInput().func_77969_a(input)) && (recipe2.getOredict() == null || !OreDictionaryUtilities.isSameOre(input, recipe2.getOredict()))) continue;
                return (T)recipe2;
            }
        }
        return null;
    }

    public static boolean isRecipeInput(Object handle, ItemStack input) {
        if (input != null) {
            for (RecipeSystemTemplate recipe2 : RecipeSystem.getHandleRecipes(handle)) {
                if ((recipe2.getInput() == null || !recipe2.getInput().func_77969_a(input)) && (recipe2.getOredict() == null || !OreDictionaryUtilities.isSameOre(input, recipe2.getOredict()))) continue;
                return true;
            }
        }
        return false;
    }
}

