/*
 * Decompiled with CFR 0.152.
 */
package physica.library.tile;

import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import physica.api.core.abstraction.Face;
import physica.api.core.conductor.EnumConductorType;
import physica.api.core.conductor.IConductor;
import physica.library.location.GridLocation;
import physica.library.net.ElectricNetworkRegistry;
import physica.library.net.energy.ElectricNetwork;

public class TileConductor
extends TileEntity
implements IConductor {
    public ElectricNetwork energyNetwork;

    public boolean canUpdate() {
        return false;
    }

    @Override
    public ElectricNetwork getNetwork() {
        return this.getNetwork(true);
    }

    @Override
    public void setNetwork(ElectricNetwork network) {
        if (network != this.energyNetwork) {
            this.removeFromNetwork();
            this.energyNetwork = network;
        }
    }

    public TileEntity[] getConnectedCables(TileEntity tileEntity) {
        TileEntity[] cables = new TileEntity[]{null, null, null, null, null, null};
        for (Face orientation : Face.VALID) {
            TileEntity cable = new GridLocation(tileEntity).OffsetFace(orientation).getTile((IBlockAccess)tileEntity.func_145831_w());
            if (!(cable instanceof IConductor)) continue;
            cables[orientation.ordinal()] = cable;
        }
        return cables;
    }

    @Override
    public ElectricNetwork getNetwork(boolean createIfNull) {
        if (this.energyNetwork == null && createIfNull) {
            TileEntity[] adjacentCables = this.getConnectedCables(this);
            HashSet<ElectricNetwork> connectedNets = new HashSet<ElectricNetwork>();
            for (TileEntity cable : adjacentCables) {
                if (!(cable instanceof IConductor) || ((IConductor)cable).getNetwork(false) == null) continue;
                connectedNets.add(((IConductor)cable).getNetwork());
            }
            if (connectedNets.size() == 0) {
                this.energyNetwork = new ElectricNetwork(this);
            } else if (connectedNets.size() == 1) {
                this.energyNetwork = (ElectricNetwork)connectedNets.toArray()[0];
                this.energyNetwork.conductorSet.add(this);
            } else {
                this.energyNetwork = new ElectricNetwork(connectedNets);
                this.energyNetwork.conductorSet.add(this);
            }
        }
        return this.energyNetwork;
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.getNetwork().split(this);
        }
        super.func_145843_s();
    }

    @Override
    public void refreshNetwork() {
        if (!this.field_145850_b.field_72995_K) {
            for (Face side : Face.VALID) {
                TileEntity tileEntity = new GridLocation(this).OffsetFace(side).getTile((IBlockAccess)this.field_145850_b);
                if (!(tileEntity instanceof IConductor)) continue;
                this.getNetwork().merge(((IConductor)tileEntity).getNetwork());
            }
            this.getNetwork().refresh();
        }
    }

    @Override
    public void removeFromNetwork() {
        if (this.energyNetwork != null) {
            this.energyNetwork.removeCable(this);
        }
    }

    @Override
    public void fixNetwork() {
        this.getNetwork().fixMessedUpNetwork(this);
    }

    @Override
    public int getElectricCapacity(Face from) {
        return this.getCableType().getTransferRate();
    }

    @Override
    public EnumConductorType getCableType() {
        return EnumConductorType.values()[Math.max(0, Math.min(EnumConductorType.values().length - 1, this.func_145832_p()))];
    }

    @Override
    public int receiveElectricity(Face from, int maxReceive, boolean simulate) {
        if (simulate) {
            return 0;
        }
        ArrayList<TileEntity> ignored = new ArrayList<TileEntity>();
        ignored.add(new GridLocation(this).OffsetFace(from).getTile((IBlockAccess)this.field_145850_b));
        return this.getNetwork().emit(maxReceive, ignored);
    }

    @Override
    public boolean canConnectElectricity(Face from) {
        return true;
    }

    public void onChunkUnload() {
        this.func_145843_s();
        ElectricNetworkRegistry.getInstance().pruneEmptyNetworks();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public void destroyNodeViolently() {
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150480_ab);
    }
}

