/*
 * Decompiled with CFR 0.152.
 */
package physica.library.worldgen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderHell;
import physica.api.core.abstraction.Face;
import physica.library.location.GridLocation;
import physica.library.worldgen.AbstractOreGenerator;
import physica.library.worldgen.OreGeneratorSettings;

public class OreGenReplace
extends AbstractOreGenerator {
    public final OreGeneratorSettings settings;
    public boolean ignoreSurface = false;
    public boolean ignoreNether = true;
    public boolean ignoreEnd = true;

    public OreGenReplace(Block block, int meta, OreGeneratorSettings settings, String harvestTool, int harvestLevel) {
        super(block, meta, harvestTool, harvestLevel);
        this.settings = settings;
    }

    @Override
    public void generate(World world, Random random, int varX, int varZ) {
        if (this.settings.amountPerChunk > 0) {
            int placed;
            for (int blocksPlaced = 0; blocksPlaced < this.settings.amountPerChunk; blocksPlaced += placed) {
                int x = varX + random.nextInt(16);
                int z = varZ + random.nextInt(16);
                int y = random.nextInt(Math.max(this.settings.maxGenerateHeight - this.settings.minGenerateHeight, 0)) + this.settings.minGenerateHeight;
                placed = this.generateBranch(world, random, varX, varZ, x, y, z);
                if (placed > 0) continue;
                placed = this.settings.amountPerBranch;
            }
        }
    }

    public int generateBranch(World world, Random rand, int chunkCornerX, int chunkCornerZ, int varX, int varY, int varZ) {
        int blocksPlaced = 0;
        HashSet<GridLocation> pathed = new HashSet<GridLocation>();
        LinkedList<GridLocation> toPath = new LinkedList<GridLocation>();
        toPath.add(new GridLocation(varX, varY, varZ));
        ArrayList<Face> directions = new ArrayList<Face>();
        for (Face dir : Face.VALID) {
            directions.add(dir);
        }
        while (!toPath.isEmpty() && blocksPlaced < this.settings.amountPerBranch) {
            GridLocation next = (GridLocation)toPath.poll();
            pathed.add(next);
            Block block = world.func_147439_a(next.xCoord, next.yCoord, next.zCoord);
            if ((this.settings.replaceBlock == null || block == this.settings.replaceBlock) && world.func_147465_d(next.xCoord, next.yCoord, next.zCoord, this.oreBlock, this.oreMeta, 2)) {
                ++blocksPlaced;
            }
            Collections.shuffle(directions);
            for (Face direction : directions) {
                GridLocation pos = new GridLocation(next.xCoord + direction.offsetX, next.yCoord + direction.offsetY, next.zCoord + direction.offsetZ);
                if (pathed.contains(pos) || !world.field_73012_v.nextBoolean()) continue;
                if (pos.yCoord > 0 && pos.yCoord < world.func_72800_K() - 1 && world.func_72899_e(pos.xCoord, pos.yCoord, pos.zCoord)) {
                    boolean insideY;
                    boolean insideX = pos.xCoord >= chunkCornerX && pos.xCoord < chunkCornerX + 16;
                    boolean insideZ = pos.yCoord >= chunkCornerZ && pos.zCoord < chunkCornerZ + 16;
                    boolean bl = insideY = pos.zCoord >= this.settings.minGenerateHeight && pos.yCoord <= this.settings.maxGenerateHeight;
                    if (insideX && insideZ && insideY) {
                        block = world.func_147439_a(pos.xCoord, pos.yCoord, pos.zCoord);
                        if (this.settings.replaceBlock == null || block == this.settings.replaceBlock) {
                            toPath.add(pos);
                        }
                    }
                }
                if (toPath.contains(pos)) continue;
                pathed.add(pos);
            }
        }
        return blocksPlaced;
    }

    @Override
    public boolean isOreGeneratedInWorld(World world, IChunkProvider chunkGenerator) {
        return chunkGenerator instanceof ChunkProviderGenerate ? !this.ignoreSurface : (chunkGenerator instanceof ChunkProviderHell ? !this.ignoreNether : chunkGenerator instanceof ChunkProviderEnd && !this.ignoreEnd);
    }
}

