/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import physica.api.core.utilities.IBaseUtilities;
import physica.library.client.gui.GuiContainerBase;
import physica.library.energy.ElectricityDisplay;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.inventory.ContainerBase;
import physica.nuclear.common.configuration.ConfigNuclearPhysics;
import physica.nuclear.common.tile.TileReactorControlPanel;

@SideOnly(value=Side.CLIENT)
public class GuiReactorControlPanel
extends GuiContainerBase<TileReactorControlPanel>
implements IBaseUtilities {
    public GuiReactorControlPanel(EntityPlayer player, TileReactorControlPanel host) {
        super(new ContainerBase<TileReactorControlPanel>(player, host), host);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawStringCentered(StatCollector.func_74838_a((String)"tile.physicanuclearphysics:reactorControlPanel.gui"), this.field_146999_f / 2, 5);
        if (((TileReactorControlPanel)this.host).reactor == null || ((TileReactorControlPanel)this.host).reactor.func_145837_r()) {
            this.drawStringCentered("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0440\u0435\u0430\u043a\u0442\u043e\u0440", this.field_146999_f / 2, 35);
        } else {
            double ticksLeft = 0.0;
            if (((TileReactorControlPanel)this.host).reactor.hasFuelRod()) {
                ticksLeft = (((TileReactorControlPanel)this.host).reactor.func_70301_a(0).func_77958_k() - ((TileReactorControlPanel)this.host).reactor.func_70301_a(0).func_77960_j()) / (1 + Math.round(((TileReactorControlPanel)this.host).reactor.getTemperature() / 2203.5f));
            }
            float temperature = ((TileReactorControlPanel)this.host).reactor.getTemperature();
            this.drawString("\u0422\u0435\u043c\u043f\u0435\u0440\u0430\u0442\u0443\u0440\u0430: " + this.roundPrecise(temperature, 2) + " C", 9, 39);
            this.drawString("\u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c: " + this.roundPrecise(ticksLeft / 20.0, 1) + " \u0441\u0435\u043a\u0443\u043d\u0434", 9, 50);
            this.drawString("\u0412\u0432\u043e\u0434 \u0441\u0442\u0435\u0440\u0436\u043d\u044f: " + (((TileReactorControlPanel)this.host).rod != null && !((TileReactorControlPanel)this.host).rod.func_145837_r() ? ((TileReactorControlPanel)this.host).rod.getInsertion() : ((TileReactorControlPanel)this.host).reactor.getInsertion()) + "%", 9, 61);
            int productionFlux = 0;
            if (((TileReactorControlPanel)this.host).reactor.getTemperature() > 100.0f) {
                float steam = (temperature - 100.0f) / 10.0f * 0.65f * 20.0f * 20.0f * 25.0f;
                productionFlux = (int)((double)(steam * ConfigNuclearPhysics.TURBINE_STEAM_TO_RF_RATIO) / 4.0);
            }
            this.drawString("\u0422\u0435\u043e\u0440\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c", 9, 82);
            this.drawString("\u0412\u044b\u0445\u043e\u0434 \u044d\u043d\u0435\u0440\u0433\u0438\u0438: " + ElectricityDisplay.getDisplayShortTicked(ElectricityUtilities.convertEnergy(productionFlux, Unit.RF, Unit.WATT), Unit.WATT), 9, 93);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (((TileReactorControlPanel)this.host).rod != null && !((TileReactorControlPanel)this.host).rod.func_145837_r()) {
            this.addButton(new GuiButton(1, this.field_146294_l / 2 - 70, this.field_146295_m / 2 + 25, "\u0412\u0432\u0435\u0440\u0445: 5%".length() * 8, 20, "\u0412\u0432\u0435\u0440\u0445: 5%"));
            this.addButton(new GuiButton(2, this.field_146294_l / 2 - 70 + "\u0412\u0432\u0435\u0440\u0445: 5%".length() * 8 + 10, this.field_146295_m / 2 + 25, "\u0412\u043d\u0438\u0437: 5%".length() * 8, 20, "\u0412\u043d\u0438\u0437: 5%"));
            this.addButton(new GuiButton(3, this.field_146294_l / 2 - 70, this.field_146295_m / 2 + 50, "\u0410\u0432\u0430\u0440\u0438\u0439\u043d\u043e\u0435 \u043e\u0442\u043a\u043b.".length() * 8, 20, "\u0410\u0432\u0430\u0440\u0438\u0439\u043d\u043e\u0435 \u043e\u0442\u043a\u043b."));
        }
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (((TileReactorControlPanel)this.host).rod != null && !((TileReactorControlPanel)this.host).rod.func_145837_r()) {
            ((TileReactorControlPanel)this.host).rod.actionPerformed(button.field_146127_k == 1 ? -5 : (button.field_146127_k == 2 ? 5 : 100), Side.CLIENT);
        }
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        this.func_73729_b(this.containerWidth + (this.field_146999_f - this.electricityMeterWidth) / 2, this.containerHeight + 18, 54, 0, this.electricityMeterWidth, this.electricityMeterHeight);
        if (((TileReactorControlPanel)this.host).reactor != null && ((TileReactorControlPanel)this.host).reactor.getTemperature() > 0.0f) {
            this.func_73733_a((int)((float)(this.containerWidth + (this.field_146999_f - this.electricityMeterWidth) / 2) + Math.min(((TileReactorControlPanel)this.host).reactor.getTemperature(), 4407.0f) / 4407.0f * (float)this.electricityMeterWidth - 1.0f), this.containerHeight + 18 + this.electricityMeterHeight - 1, this.containerWidth + (this.field_146999_f - this.electricityMeterWidth) / 2 + 1, this.containerHeight + 18 + 1, ((TileReactorControlPanel)this.host).reactor.getTemperature() < 4407.0f ? Color.yellow.getRGB() : Color.red.getRGB(), Color.red.getRGB());
        }
    }
}

