/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import physica.core.client.nei.PhysicaRecipeHandlerBase;
import physica.library.recipe.RecipeSystem;
import physica.nuclear.client.gui.GuiChemicalBoiler;
import physica.nuclear.common.NuclearFluidRegister;
import physica.nuclear.common.recipe.type.ChemicalBoilerRecipe;
import physica.nuclear.common.tile.TileChemicalBoiler;

public class ChemicalBoilerRecipeHandler
extends PhysicaRecipeHandlerBase {
    @Override
    public String getRecipeName() {
        return "Chemical Boiler";
    }

    public String getRecipeID() {
        return "Physica.ChemicalBoiler";
    }

    public Class<GuiChemicalBoiler> getGuiClass() {
        return GuiChemicalBoiler.class;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.cycleticks += 28;
    }

    public void drawBackground(int i) {
        recipe theRecipe = (recipe)((Object)this.arecipes.get(i));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-1, (int)0, (int)this.xOffset, (int)this.yOffset, (int)169, (int)62);
        this.drawFluidTank(8, 8, new FluidStack(FluidRegistry.WATER, (int)((float)theRecipe.waterAmount * (1.0f - (float)(this.cycleticks % 1400) / 1400.0f))));
        this.drawFluidTank(145, 8, new FluidStack(NuclearFluidRegister.LIQUID_HE, theRecipe.hexaAmount));
        this.renderFurnaceCookArrow(30, 24, 0.0, 500.0);
        this.renderFurnaceCookArrow(118, 24, 0.0, 500.0);
        this.drawSlot(68, 33, true);
        this.drawSlot(68, 13, false);
        this.drawSlot(88, 13, false);
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void drawExtras(int recipe2) {
        this.mc.field_71446_o.func_110577_a(GUI_COMPONENTS);
        this.drawDoubleProgressBar(30, 24, 18, 15, 22, 15, 1400, 0, true);
        this.drawDoubleProgressBar(118, 24, 18, 15, 22, 15, 1400, 0, false);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        block5: {
            block4: {
                if (!outputId.equals(this.getRecipeID())) break block4;
                for (ChemicalBoilerRecipe newRecipe : RecipeSystem.getHandleRecipes(TileChemicalBoiler.class)) {
                    if (newRecipe.getInput() != null) {
                        this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getHexafluorideGenerated(), newRecipe.getInput().func_77973_b()));
                        continue;
                    }
                    this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getHexafluorideGenerated(), newRecipe.getOredict()));
                }
                break block5;
            }
            if (!outputId.equals("fluid") || !(results[0] instanceof FluidStack) || ((FluidStack)results[0]).getFluid() != NuclearFluidRegister.LIQUID_HE) break block5;
            for (ChemicalBoilerRecipe newRecipe : RecipeSystem.getHandleRecipes(TileChemicalBoiler.class)) {
                if (newRecipe.getInput() != null) {
                    this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getHexafluorideGenerated(), newRecipe.getInput().func_77973_b()));
                    continue;
                }
                this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getHexafluorideGenerated(), newRecipe.getOredict()));
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("item") && ingredients[0] instanceof ItemStack && RecipeSystem.getRecipe(TileChemicalBoiler.class, (ItemStack)ingredients[0]) != null) {
            ChemicalBoilerRecipe newRecipe = (ChemicalBoilerRecipe)RecipeSystem.getRecipe(TileChemicalBoiler.class, (ItemStack)ingredients[0]);
            if (newRecipe.getInput() != null) {
                this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getHexafluorideGenerated(), newRecipe.getInput().func_77973_b()));
            } else {
                this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getHexafluorideGenerated(), newRecipe.getOredict()));
            }
        } else if (inputId.equals("fluid") && ingredients[0] instanceof FluidStack && ((FluidStack)ingredients[0]).getFluid() == FluidRegistry.WATER) {
            for (ChemicalBoilerRecipe newRecipe : RecipeSystem.getHandleRecipes(TileChemicalBoiler.class)) {
                if (newRecipe.getInput() != null) {
                    this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getHexafluorideGenerated(), newRecipe.getInput().func_77973_b()));
                    continue;
                }
                this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getHexafluorideGenerated(), newRecipe.getOredict()));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe2) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe2);
        Point relMouse = new Point(point.x - (gui.field_146294_l - 176) / 2 - offset.x, point.y - (gui.field_146295_m - 166) / 2 - offset.y);
        recipe theRecipe = (recipe)((Object)this.arecipes.get(recipe2));
        if (relMouse.x > 8 && relMouse.x < 8 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
            currenttip.add("\u0412\u043e\u0434\u0430: " + theRecipe.waterAmount + "/5000\u043c\u043b");
        } else if (relMouse.x > 145 && relMouse.x < 145 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
            currenttip.add("\u0413\u0435\u043a\u0441\u0430\u0444\u0442\u043e\u0440\u0438\u0434: " + theRecipe.hexaAmount + "/5000\u043c\u043b");
        }
        return super.handleTooltip(gui, currenttip, recipe2);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(30, 24, 22, 15), this.getRecipeID(), new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(118, 24, 22, 15), this.getRecipeID(), new Object[0]));
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe2) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe2);
        Point relMouse = new Point(point.x - (gui.field_146294_l - 176) / 2 - offset.x, point.y - (gui.field_146295_m - 166) / 2 - offset.y);
        if (button == 0) {
            if (relMouse.x > 145 && relMouse.x < 145 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
                GuiCraftingRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(NuclearFluidRegister.LIQUID_HE, 1000)});
                return true;
            }
            if (relMouse.x > 8 && relMouse.x < 8 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
                GuiCraftingRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(FluidRegistry.WATER, 1000)});
                return true;
            }
        } else if (button == 1) {
            if (relMouse.x > 145 && relMouse.x < 145 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
                GuiUsageRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(NuclearFluidRegister.LIQUID_HE, 1000)});
                return true;
            }
            if (relMouse.x > 8 && relMouse.x < 8 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
                GuiUsageRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(FluidRegistry.WATER, 1000)});
                return true;
            }
        }
        return super.mouseClicked(gui, button, recipe2);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe2) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe2);
        Point relMouse = new Point(point.x - (gui.field_146294_l - 176) / 2 - offset.x, point.y - (gui.field_146295_m - 166) / 2 - offset.y);
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe")) {
            if (relMouse.x > 145 && relMouse.x < 145 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
                GuiCraftingRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(NuclearFluidRegister.LIQUID_HE, 1000)});
                return true;
            }
            if (relMouse.x > 8 && relMouse.x < 8 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
                GuiCraftingRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(FluidRegistry.WATER, 1000)});
                return true;
            }
        } else if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage")) {
            if (relMouse.x > 145 && relMouse.x < 145 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
                GuiUsageRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(NuclearFluidRegister.LIQUID_HE, 1000)});
                return true;
            }
            if (relMouse.x > 8 && relMouse.x < 8 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
                GuiUsageRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(FluidRegistry.WATER, 1000)});
                return true;
            }
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe2);
    }

    class recipe
    extends TemplateRecipeHandler.CachedRecipe {
        public int waterAmount;
        public int hexaAmount;
        public Item iteminput;
        public String oreDict;

        public recipe(int WaterAmount, int HexaAmount, Item Input) {
            super((TemplateRecipeHandler)ChemicalBoilerRecipeHandler.this);
            this.waterAmount = WaterAmount;
            this.hexaAmount = HexaAmount;
            this.iteminput = Input;
        }

        public recipe(int WaterAmount, int HexaAmount, String Input) {
            super((TemplateRecipeHandler)ChemicalBoilerRecipeHandler.this);
            this.waterAmount = WaterAmount;
            this.hexaAmount = HexaAmount;
            this.oreDict = Input;
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)new ItemStack(this.iteminput), 89, 14);
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> ingredients = new ArrayList<PositionedStack>();
            if (this.oreDict != null) {
                ingredients.add(new PositionedStack((Object)OreDictionary.getOres((String)this.oreDict), 89, 14));
            } else {
                ingredients.add(new PositionedStack((Object)new ItemStack(this.iteminput), 89, 14));
            }
            return this.getCycledIngredients(ChemicalBoilerRecipeHandler.this.cycleticks / 1400, ingredients);
        }
    }
}

