/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import physica.core.client.nei.PhysicaRecipeHandlerBase;
import physica.library.recipe.RecipeSystem;
import physica.nuclear.client.gui.GuiChemicalExtractor;
import physica.nuclear.common.recipe.type.ChemicalExtractorRecipe;
import physica.nuclear.common.tile.TileChemicalExtractor;

public class ChemicalExtractorRecipeHandler
extends PhysicaRecipeHandlerBase {
    @Override
    public String getRecipeName() {
        return "Chemical Extractor";
    }

    public String getRecipeID() {
        return "Physica.ChemicalExtractor";
    }

    public Class<GuiChemicalExtractor> getGuiClass() {
        return GuiChemicalExtractor.class;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.cycleticks += 18;
    }

    public void drawBackground(int i) {
        recipe theRecipe = (recipe)((Object)this.arecipes.get(i));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-1, (int)0, (int)this.xOffset, (int)this.yOffset, (int)169, (int)62);
        this.drawFluidTank(8, 8, new FluidStack(FluidRegistry.WATER, (int)((float)theRecipe.waterAmount * (1.0f - (float)(this.cycleticks % 900) / 900.0f))));
        this.renderFurnaceCookArrow(36, 24, 0.0, 900.0);
        this.drawSlot(131, 21, true);
        this.drawSlot(81, 21, false);
        this.drawSlot(101, 21, false);
    }

    public void drawExtras(int recipe2) {
        this.mc.field_71446_o.func_110577_a(GUI_COMPONENTS);
        this.drawProgressBar(36, 24, 18, 15, 22, 15, 900, 0);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(36, 24, 22, 15), this.getRecipeID(), new Object[0]));
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        block5: {
            block4: {
                if (!outputId.equals(this.getRecipeID())) break block4;
                for (ChemicalExtractorRecipe newRecipe : RecipeSystem.getHandleRecipes(TileChemicalExtractor.class)) {
                    if (newRecipe.getInput() != null) {
                        this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getInput().func_77973_b(), newRecipe.getOutput()));
                        continue;
                    }
                    this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getOredict(), newRecipe.getOutput()));
                }
                break block5;
            }
            if (!outputId.equals("item") || !(results[0] instanceof ItemStack)) break block5;
            for (ChemicalExtractorRecipe newRecipe : RecipeSystem.getHandleRecipes(TileChemicalExtractor.class)) {
                if (newRecipe.getOutput().func_77973_b() != ((ItemStack)results[0]).func_77973_b() || newRecipe.getOutput().func_77960_j() != ((ItemStack)results[0]).func_77960_j()) continue;
                if (newRecipe.getInput() != null) {
                    this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getInput().func_77973_b(), newRecipe.getOutput()));
                    continue;
                }
                this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getOredict(), newRecipe.getOutput()));
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("item") && ingredients[0] instanceof ItemStack && RecipeSystem.getRecipe(TileChemicalExtractor.class, (ItemStack)ingredients[0]) != null) {
            ChemicalExtractorRecipe newRecipe = (ChemicalExtractorRecipe)RecipeSystem.getRecipe(TileChemicalExtractor.class, (ItemStack)ingredients[0]);
            if (newRecipe.getInput() != null) {
                this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getInput().func_77973_b(), newRecipe.getOutput()));
            } else {
                this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getOredict(), newRecipe.getOutput()));
            }
        } else if (inputId.equals("fluid") && ingredients[0] instanceof FluidStack && ((FluidStack)ingredients[0]).getFluid() == FluidRegistry.WATER) {
            for (ChemicalExtractorRecipe newRecipe : RecipeSystem.getHandleRecipes(TileChemicalExtractor.class)) {
                if (newRecipe.getInput() != null) {
                    this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getInput().func_77973_b(), newRecipe.getOutput()));
                    continue;
                }
                this.arecipes.add(new recipe(newRecipe.getWaterUse(), newRecipe.getOredict(), newRecipe.getOutput()));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe2) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe2);
        Point relMouse = new Point(point.x - (gui.field_146294_l - 176) / 2 - offset.x, point.y - (gui.field_146295_m - 166) / 2 - offset.y);
        recipe theRecipe = (recipe)((Object)this.arecipes.get(recipe2));
        if (relMouse.x > 8 && relMouse.x < 8 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
            currenttip.add("\u0412\u043e\u0434\u0430: " + theRecipe.waterAmount + "/5000\u043c\u043b");
        }
        return super.handleTooltip(gui, currenttip, recipe2);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe2) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe2);
        Point relMouse = new Point(point.x - (gui.field_146294_l - 176) / 2 - offset.x, point.y - (gui.field_146295_m - 166) / 2 - offset.y);
        if (button == 0) {
            if (relMouse.x > 8 && relMouse.x < 8 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
                GuiCraftingRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(FluidRegistry.WATER, 1000)});
                return true;
            }
        } else if (button == 1 && relMouse.x > 8 && relMouse.x < 8 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
            GuiUsageRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(FluidRegistry.WATER, 1000)});
            return true;
        }
        return super.mouseClicked(gui, button, recipe2);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe2) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe2);
        Point relMouse = new Point(point.x - (gui.field_146294_l - 176) / 2 - offset.x, point.y - (gui.field_146295_m - 166) / 2 - offset.y);
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe")) {
            if (relMouse.x > 8 && relMouse.x < 8 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
                GuiCraftingRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(FluidRegistry.WATER, 1000)});
                return true;
            }
        } else if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && relMouse.x > 8 && relMouse.x < 8 + this.meterWidth && relMouse.y > 8 && relMouse.y < 8 + this.meterHeight) {
            GuiUsageRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{new FluidStack(FluidRegistry.WATER, 1000)});
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe2);
    }

    class recipe
    extends TemplateRecipeHandler.CachedRecipe {
        public int waterAmount;
        public ItemStack itemoutput;
        public Item iteminput;
        public String oreDict;

        public recipe(int WaterAmount, Item Input, ItemStack Output) {
            super((TemplateRecipeHandler)ChemicalExtractorRecipeHandler.this);
            this.waterAmount = WaterAmount;
            this.itemoutput = Output;
            this.iteminput = Input;
        }

        public recipe(int WaterAmount, String Input, ItemStack Output) {
            super((TemplateRecipeHandler)ChemicalExtractorRecipeHandler.this);
            this.waterAmount = WaterAmount;
            this.itemoutput = Output;
            this.oreDict = Input;
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)new ItemStack(this.iteminput), 82, 22);
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> ingredients = new ArrayList<PositionedStack>();
            if (this.oreDict != null) {
                ingredients.add(new PositionedStack((Object)OreDictionary.getOres((String)this.oreDict), 82, 22));
            } else {
                ingredients.add(new PositionedStack((Object)new ItemStack(this.iteminput), 82, 22));
            }
            return this.getCycledIngredients(ChemicalExtractorRecipeHandler.this.cycleticks / 900, ingredients);
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.itemoutput, 102, 22);
        }
    }
}

