/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.client.render.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import physica.api.core.utilities.IBaseUtilities;
import physica.library.client.render.TessellatorWrapper;
import physica.library.client.render.TileRenderObjModel;
import physica.library.location.GridLocation;
import physica.nuclear.common.tile.TileQuantumAssembler;

@SideOnly(value=Side.CLIENT)
public class TileRenderAssembler
extends TileRenderObjModel<TileQuantumAssembler>
implements IBaseUtilities {
    protected static final ResourceLocation enderDragonCrystalBeamTextures = new ResourceLocation("textures/entity/endercrystal/endercrystal_beam.png");
    protected static final RenderItem renderItem = (RenderItem)RenderManager.field_78727_a.func_78715_a(EntityItem.class);
    protected float current = 0.0f;
    protected float lastOperating = 0.0f;
    protected boolean goesDown = false;

    public TileRenderAssembler(String objFile, String textureFile) {
        super(objFile, textureFile, "physicanuclearphysics", "models/", "textures/models/");
    }

    @Override
    public void renderTileAt(TileQuantumAssembler tile, double x, double y, double z, float deltaFrame) {
        super.renderTileAt(tile, x, y, z, deltaFrame);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.4), (double)(z + 0.5));
        GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
        EntityItem entity = tile.getEntityItem();
        if (entity != null) {
            entity.func_92059_d().field_77994_a = Math.max(1, Math.min(5, entity.func_92059_d().field_77994_a));
            entity.field_70292_b = 1;
            entity.field_70290_d = 0.0f;
            renderItem.func_76986_a(tile.getEntityItem(), 0.0, 0.0, 0.0, 0.0f, 5.0f);
            float down = 4.0f;
            float forward = 0.125f;
            GL11.glScalef((float)(1.0f / down), (float)0.333f, (float)(1.0f / down));
            if (tile.getOperatingTicks() > 0) {
                GridLocation loc = tile.getLocation();
                double centerX = (double)((float)loc.xCoord + (float)tile.getFacing().offsetX * down * forward) + 0.5 * (double)down;
                double centerY = (double)loc.yCoord + 0.4 * (double)down;
                double centerZ = (double)((float)loc.zCoord + (float)tile.getFacing().offsetX * down * forward) + 0.5 * (double)down;
                double targetX = (double)((float)loc.xCoord + (float)tile.getFacing().offsetX * down * forward) + 0.5 * (double)down + (double)(tile.func_145831_w().field_73012_v.nextFloat() / down) - (double)(1.0f / down) / 1.333;
                double targetY = (double)loc.yCoord + 0.9 * (double)down * 2.0;
                double targetZ = (double)((float)loc.xCoord + (float)tile.getFacing().offsetX * down * forward) + 0.5 * (double)down + (double)(tile.func_145831_w().field_73012_v.nextFloat() / down) - (double)(1.0f / down) / 1.333;
                double relX = (float)tile.getFacing().offsetX * down * forward;
                double relY = 0.6 + (double)(tile.func_145831_w().field_73012_v.nextFloat() / down);
                double relZ = (float)tile.getFacing().offsetZ * down * forward;
                float dirX = (float)(targetX - centerX);
                float dirY = (float)(targetY - centerY);
                float dirZ = (float)(targetZ - centerZ);
                float zCorner = MathHelper.func_76129_c((float)(dirX * dirX + dirY * dirY + dirZ * dirZ));
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)relX), (float)((float)relY), (float)((float)relZ));
                GL11.glRotatef((float)((float)(-Math.atan2(dirZ, dirX)) * 180.0f / (float)Math.PI - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((float)(-Math.atan2(MathHelper.func_76129_c((float)(dirX * dirX + dirZ * dirZ)), dirY)) * 180.0f / (float)Math.PI - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                TessellatorWrapper tessellator = TessellatorWrapper.instance;
                RenderHelper.func_74518_a();
                GL11.glDisable((int)2884);
                this.func_147499_a(enderDragonCrystalBeamTextures);
                GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
                GL11.glShadeModel((int)7425);
                for (int i = 0; i < 5; ++i) {
                    float u1 = -((float)tile.getOperatingTicks() * deltaFrame * tile.func_145831_w().field_73012_v.nextFloat() * (float)(i + 1) * 0.005f);
                    float u2 = MathHelper.func_76129_c((float)(dirX * dirX + dirY * dirY + dirZ * dirZ)) / 32.0f + u1;
                    tessellator.startDrawing(5);
                    int total = 8;
                    for (int j = 0; j <= total; ++j) {
                        float xCorner = 0.2f * (MathHelper.func_76126_a((float)((float)(j % total) * (float)Math.PI * 2.0f / (float)total)) * 0.75f);
                        float yCorner = 0.2f * (MathHelper.func_76134_b((float)((float)(j % total) * (float)Math.PI * 2.0f / (float)total)) * 0.75f);
                        float u = (float)(j % total) * 1.0f / (float)total;
                        tessellator.setColorOpaque(200 - Math.abs(60 - tile.getOperatingTicks() % 10 * 12), 0, 0);
                        tessellator.addVertexWithUV(xCorner, yCorner, 0.0, u, u2);
                        tessellator.setColorOpaque_I(0xFFFFFF);
                        tessellator.addVertexWithUV(xCorner, yCorner, zCorner, u, u1);
                    }
                    tessellator.draw();
                }
                GL11.glEnable((int)2884);
                GL11.glShadeModel((int)7424);
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }
}

