/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import physica.api.core.abstraction.Face;
import physica.api.core.abstraction.recipe.IRecipeRegister;
import physica.api.core.utilities.IBaseUtilities;
import physica.api.nuclear.IElectromagnet;
import physica.library.util.OreDictionaryUtilities;
import physica.nuclear.common.NuclearBlockRegister;
import physica.nuclear.common.NuclearTabRegister;

public class BlockElectromagnet
extends Block
implements IElectromagnet,
IBaseUtilities,
IRecipeRegister {
    @SideOnly(value=Side.CLIENT)
    private static IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private static IIcon iconGlass;
    @SideOnly(value=Side.CLIENT)
    private static IIcon containment;
    @SideOnly(value=Side.CLIENT)
    private static IIcon containmentIconTop;
    @SideOnly(value=Side.CLIENT)
    private static IIcon containmentIconGlass;

    public BlockElectromagnet() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(20.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149658_d("physicanuclearphysics:electromagnet");
        this.func_149663_c("physicanuclearphysics:electromagnet");
        this.func_149647_a(NuclearTabRegister.nuclearPhysicsTab);
        this.addToRegister("Nuclear", this);
    }

    @Override
    public void registerRecipes() {
        this.addRecipe(new ItemStack((Block)this, 2), new Object[]{"BSB", "SMS", "BSB", Character.valueOf('B'), OreDictionaryUtilities.getAlternatingOreItem("ingotBronze", "ingotCopper"), Character.valueOf('M'), "motor", Character.valueOf('S'), "ingotSteel"});
        this.addShapeless(new ItemStack((Block)this, 1, EnumElectromagnet.GLASS.ordinal()), new Object[]{NuclearBlockRegister.blockElectromagnet, Blocks.field_150359_w});
        this.addRecipe(new ItemStack((Block)this, 2, EnumElectromagnet.CONTAINMENT_NORMAL.ordinal()), new Object[]{"ELE", "LEL", "ELE", Character.valueOf('E'), "circuitElite", Character.valueOf('L'), new ItemStack((Block)this, 1, 0)});
        this.addShapeless(new ItemStack((Block)this, 1, EnumElectromagnet.CONTAINMENT_GLASS.ordinal()), new Object[]{new ItemStack((Block)this, 1, EnumElectromagnet.CONTAINMENT_NORMAL.ordinal()), Blocks.field_150359_w});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        iconTop = iconRegister.func_94245_a("physicanuclearphysics:electromagnettop");
        iconGlass = iconRegister.func_94245_a("physicanuclearphysics:electromagnetglass");
        containment = iconRegister.func_94245_a("physicanuclearphysics:containmentblock");
        containmentIconTop = iconRegister.func_94245_a("physicanuclearphysics:containmenttop");
        containmentIconGlass = iconRegister.func_94245_a("physicanuclearphysics:containmentglass");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (metadata == EnumElectromagnet.NORMAL.ordinal() || metadata == EnumElectromagnet.CONTAINMENT_NORMAL.ordinal()) {
            if (side == 0 || side == 1) {
                return metadata == EnumElectromagnet.NORMAL.ordinal() ? iconTop : containmentIconTop;
            }
            if (metadata == EnumElectromagnet.NORMAL.ordinal()) {
                return this.field_149761_L;
            }
            return containment;
        }
        if (metadata == EnumElectromagnet.GLASS.ordinal()) {
            return iconGlass;
        }
        return containmentIconGlass;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149686_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        Face dir = Face.getOrientation(side).getOpposite();
        int xn = x + dir.offsetX;
        int yn = y + dir.offsetY;
        int zn = z + dir.offsetZ;
        Block neighborBlock = world.func_147439_a(xn, yn, zn);
        int neighborMetadata = world.func_72805_g(xn, yn, zn);
        return !(block == this && neighborBlock == this && (metadata == 1 && neighborMetadata == 1 || metadata == 3 && neighborMetadata == 3) || !super.func_149646_a(world, x, y, z, side));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumElectromagnet type : EnumElectromagnet.values()) {
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        world.func_72921_c(x, y, z, itemStack.func_77960_j(), 3);
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return EnumElectromagnet.values()[world.func_72805_g(x, y, z)] == EnumElectromagnet.GLASS ? 0 : super.getLightOpacity(world, x, y, z);
    }

    public static enum EnumElectromagnet {
        NORMAL,
        GLASS,
        CONTAINMENT_NORMAL,
        CONTAINMENT_GLASS;


        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

