/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import physica.api.core.abstraction.Face;
import physica.api.core.misc.IRotatable;
import physica.library.block.BlockBaseContainerModelled;
import physica.nuclear.common.NuclearBlockRegister;
import physica.nuclear.common.NuclearTabRegister;
import physica.nuclear.common.tile.TileFissionReactor;
import physica.nuclear.common.tile.TileInsertableControlRod;

public class BlockInsertableControlRod
extends BlockBaseContainerModelled {
    public BlockInsertableControlRod() {
        super(Material.field_151573_f);
        this.func_149711_c(10.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(NuclearTabRegister.nuclearPhysicsTab);
        this.func_149663_c("physicanuclearphysics:insertableControlRod");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileInsertableControlRod();
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float minX = 0.25f;
        float minY = 0.0f;
        float minZ = 0.25f;
        float maxX = 0.75f;
        float maxY = 1.0f;
        float maxZ = 0.75f;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileInsertableControlRod) {
            TileInsertableControlRod controlRod = (TileInsertableControlRod)tile;
            Face dir = controlRod.getFacing().getOpposite();
            if (dir == Face.DOWN) {
                maxY = (float)(0.25 + (double)(100 - controlRod.getInsertion()) / 120.0);
            } else {
                minY = 1.0f - (float)(0.25 + (double)(100 - controlRod.getInsertion()) / 120.0);
                maxY = 1.0f;
            }
        }
        this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack item) {
        IRotatable tile = (IRotatable)world.func_147438_o(x, y, z);
        for (Face dir : Face.VALID) {
            if (dir.ordinal() > 1) break;
            if (!(world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) instanceof TileFissionReactor) || world.func_147438_o(x + dir.offsetX, y + dir.offsetY * 2, z + dir.offsetZ) instanceof TileInsertableControlRod) continue;
            tile.setFacing(dir.getOpposite());
        }
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        Face dir = Face.getOrientation(side).getOpposite();
        return side <= 1 && super.func_149707_d(world, x, y, z, side) && world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) instanceof TileFissionReactor && !(world.func_147438_o(x + dir.offsetX, y + dir.offsetY * 2, z + dir.offsetZ) instanceof TileInsertableControlRod);
    }

    @Override
    public void registerRecipes() {
        this.addRecipe((Block)this, new Object[]{"SMS", "IAI", "SSS", Character.valueOf('I'), NuclearBlockRegister.blockControlRod, Character.valueOf('S'), "plateSteel", Character.valueOf('A'), "circuitElite", Character.valueOf('M'), "motor"});
    }

    @Override
    public boolean canRotate(int ordinal) {
        return false;
    }

    @Override
    public String getSide() {
        return "Nuclear";
    }
}

