/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import physica.api.core.abstraction.Face;
import physica.api.core.misc.IRotatable;
import physica.core.common.CoreItemRegister;
import physica.library.block.BlockBaseContainerModelled;
import physica.nuclear.common.NuclearTabRegister;
import physica.nuclear.common.tile.TileFissionReactor;
import physica.nuclear.common.tile.TileNeutronCaptureChamber;

public class BlockNeutronCaptureChamber
extends BlockBaseContainerModelled {
    public BlockNeutronCaptureChamber() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(NuclearTabRegister.nuclearPhysicsTab);
        this.func_149663_c("physicanuclearphysics:neutronCaptureChamber");
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileNeutronCaptureChamber) {
            TileNeutronCaptureChamber neutronChamber = (TileNeutronCaptureChamber)tile;
            minY = 0.05f;
            maxY = 0.95f;
            Face dir = neutronChamber.getFacing().getOpposite();
            switch (dir) {
                case EAST: {
                    minX = 0.8f;
                    maxX = 1.1f;
                    minZ = 0.265f;
                    maxZ = 0.735f;
                    break;
                }
                case NORTH: {
                    minZ = -0.19999999f;
                    maxZ = 0.19999999f;
                    minX = 0.265f;
                    maxX = 0.735f;
                    break;
                }
                case SOUTH: {
                    minZ = 0.8f;
                    maxZ = 1.1f;
                    minX = 0.265f;
                    maxX = 0.735f;
                    break;
                }
                case WEST: {
                    minX = -0.19999999f;
                    maxX = 0.19999999f;
                    minZ = 0.265f;
                    maxZ = 0.735f;
                    break;
                }
            }
        }
        this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack item) {
        IRotatable tile = (IRotatable)world.func_147438_o(x, y, z);
        for (Face dir : Face.VALID) {
            if (dir.ordinal() <= 1 || !(world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) instanceof TileFissionReactor)) continue;
            tile.setFacing(dir.getOpposite());
        }
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        Face dir = Face.getOrientation(side).getOpposite();
        return side > 1 && super.func_149707_d(world, x, y, z, side) && world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) instanceof TileFissionReactor;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileNeutronCaptureChamber();
    }

    @Override
    public void registerRecipes() {
        this.addRecipe((Block)this, new Object[]{"SSS", "SGC", "SSS", Character.valueOf('S'), "plateSteel", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w), Character.valueOf('C'), CoreItemRegister.itemEmptyCell});
    }

    @Override
    public String getSide() {
        return "Nuclear";
    }
}

