/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import physica.nuclear.common.NuclearTabRegister;
import physica.nuclear.common.entity.EntityParticle;
import physica.nuclear.common.radiation.RadiationSystem;

public class BlockRadioactiveGrass
extends BlockGrass {
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon snowVersion;

    public BlockRadioactiveGrass() {
        this.func_149647_a(NuclearTabRegister.nuclearPhysicsTab);
        this.func_149663_c("physicanuclearphysics:radioactiveGrass");
        this.func_149711_c(0.6f);
        this.func_149672_a(field_149779_h);
        this.func_149658_d("grass");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if ((double)random.nextFloat() < 0.1667) {
            for (int i = 0; i < 2; ++i) {
                if (!((double)random.nextFloat() < 0.666)) continue;
                world.func_72869_a("reddust", (double)x + random.nextDouble() * 3.0 - 1.5, (double)y + random.nextDouble() * 3.0 - 1.5, (double)z + random.nextDouble() * 3.0 - 1.5, (double)0.01f, 1.0, (double)0.01f);
            }
        }
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, x, y + 1, z);
        return plantType == EnumPlantType.Plains;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? this.topIcon : (side == 0 ? Blocks.field_150346_d.func_149733_h(side) : this.field_149761_L);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K && world.field_73012_v.nextFloat() < 0.666f) {
            RadiationSystem.spreadRadioactiveBlock(world, x, y, z);
        }
    }

    public void func_149724_b(World world, int x, int y, int z, Entity ent) {
        if (ent instanceof EntityParticle) {
            return;
        }
        if (ent instanceof EntityLivingBase) {
            int meta = world.func_72805_g(x, y, z);
            RadiationSystem.applyRontgenEntity((EntityLivingBase)ent, (float)meta / 2.5f, meta, 1.0f, 1.0f);
        }
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return Blocks.field_150349_c.func_149720_d(world, x, y, z) - 10;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Blocks.field_150346_d.func_149650_a(0, p_149650_2_, p_149650_3_);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (side == 1) {
            return this.topIcon;
        }
        if (side == 0) {
            return Blocks.field_150346_d.func_149733_h(side);
        }
        Material material = world.func_147439_a(x, y + 1, z).func_149688_o();
        return material != Material.field_151597_y && material != Material.field_151596_z ? this.field_149761_L : this.snowVersion;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a(this.func_149641_N() + "_side");
        this.topIcon = p_149651_1_.func_94245_a(this.func_149641_N() + "_top");
        this.snowVersion = p_149651_1_.func_94245_a("grass_side_snowed");
    }
}

