/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import physica.Physica;
import physica.api.core.abstraction.Face;
import physica.api.nuclear.IElectromagnet;
import physica.library.energy.base.Measurement;
import physica.nuclear.common.configuration.ConfigNuclearPhysics;
import physica.nuclear.common.effect.damage.DamageSourceRadiation;
import physica.nuclear.common.tile.TileParticleAccelerator;

public class EntityParticle
extends Entity
implements IEntityAdditionalSpawnData {
    private static final int movementTicketUpdateId = 20;
    public ForgeChunkManager.Ticket updateTicket;
    public double lastCheckX;
    public double lastCheckY;
    public double lastCheckZ;
    private boolean didCollide;
    private int hostLocationX;
    private int hostLocationY;
    private int hostLocationZ;
    private Face movementDirection = Face.NORTH;

    public EntityParticle(World world) {
        super(world);
        this.field_70158_ak = true;
        this.func_70105_a(0.1f, 0.1f);
    }

    public EntityParticle(World world, int x, int y, int z, Face movementDirection) {
        this(world);
        this.movementDirection = movementDirection;
        this.hostLocationX = x + this.movementDirection.getOpposite().offsetX;
        this.hostLocationY = y + this.movementDirection.getOpposite().offsetY;
        this.hostLocationZ = z + this.movementDirection.getOpposite().offsetZ;
        this.accelerateParticle(0.001f);
        this.func_70107_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
    }

    public static boolean canSpawnParticle(World world, int x, int y, int z) {
        if (world.func_147437_c(x, y, z)) {
            int electromagnetCount = 0;
            for (Face side : Face.VALID) {
                if (!EntityParticle.isElectromagnet(world, x, y, z, side) || ++electromagnetCount < 4) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isElectromagnet(World world, int x, int y, int z, Face facing) {
        return world.func_147439_a(x + facing.offsetX, y + facing.offsetY, z + facing.offsetZ) instanceof IElectromagnet;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    protected void accelerateParticle(float acceleration) {
        double accelerationX = (float)this.movementDirection.offsetX * acceleration;
        double accelerationY = (float)this.movementDirection.offsetY * acceleration;
        double accelerationZ = (float)this.movementDirection.offsetZ * acceleration;
        this.field_70159_w = Math.min(this.field_70159_w + accelerationX, (double)ConfigNuclearPhysics.ANTIMATTER_CREATION_SPEED + 0.1);
        this.field_70181_x = Math.min(this.field_70181_x + accelerationY, (double)ConfigNuclearPhysics.ANTIMATTER_CREATION_SPEED + 0.1);
        this.field_70179_y = Math.min(this.field_70179_y + accelerationZ, (double)ConfigNuclearPhysics.ANTIMATTER_CREATION_SPEED + 0.1);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.hostLocationX);
        data.writeInt(this.hostLocationY);
        data.writeInt(this.hostLocationZ);
        data.writeInt(this.movementDirection.ordinal());
    }

    public void readSpawnData(ByteBuf data) {
        this.hostLocationX = data.readInt();
        this.hostLocationY = data.readInt();
        this.hostLocationZ = data.readInt();
        this.movementDirection = Face.getOrientation(data.readInt());
    }

    public void func_70071_h_() {
        TileEntity tile = this.field_70170_p.func_147438_o(this.hostLocationX, this.hostLocationY, this.hostLocationZ);
        if (tile instanceof TileParticleAccelerator) {
            int flPosX = (int)Math.floor(this.field_70165_t);
            int flPosY = (int)Math.floor(this.field_70163_u);
            int flPosZ = (int)Math.floor(this.field_70161_v);
            TileParticleAccelerator accelerator = (TileParticleAccelerator)tile;
            if (ConfigNuclearPhysics.ENABLE_PARTICLE_CHUNKLOADING) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.updateTicket, (ChunkCoordIntPair)new ChunkCoordIntPair((int)this.field_70165_t >> 4, (int)this.field_70161_v >> 4));
            }
            if (this.field_70173_aa % 10 == 0) {
                this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "physicanuclearphysics:block.accelerator", 1.0f, (float)(0.6 + 0.4 * (this.getTotalVelocity() / (double)ConfigNuclearPhysics.ANTIMATTER_CREATION_SPEED)), true);
            }
            double acceleration = 0.002;
            if (accelerator.getParticle() == null) {
                accelerator.setParticle(this);
            }
            if ((double)accelerator.getSessionUse() > Measurement.GIGA.value) {
                this.func_70106_y();
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(20, (Object)((byte)this.movementDirection.ordinal()));
            } else {
                this.movementDirection = Face.getOrientation(this.field_70180_af.func_75683_a(20));
                if (this.field_70146_Z.nextFloat() < 2.0f) {
                    this.field_70170_p.func_72869_a("portal", this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
            }
            if (EntityParticle.isElectromagnet(this.field_70170_p, flPosX, flPosY, flPosZ, this.movementDirection)) {
                acceleration = this.turn();
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.accelerateParticle((float)acceleration);
            this.field_70160_al = true;
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.field_70142_S == this.field_70165_t && this.field_70137_T == this.field_70163_u && this.field_70136_U == this.field_70161_v && this.getTotalVelocity() <= 0.0 && this.field_70173_aa > 1) {
                this.func_70106_y();
            }
            if (ConfigNuclearPhysics.ENABLE_PARTICLE_COLLISION) {
                float radius = 0.85f;
                if (this.func_70011_f(this.lastCheckX, this.lastCheckY, this.lastCheckZ) > (double)(radius / 6.0f)) {
                    this.lastCheckX = this.field_70165_t;
                    this.lastCheckY = this.field_70163_u;
                    this.lastCheckZ = this.field_70161_v;
                    boolean withParticle = false;
                    int amount = 0;
                    List entities = this.field_70170_p.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)radius * 1.5), (double)(this.field_70163_u - (double)radius * 1.5), (double)(this.field_70161_v - (double)radius * 1.5), (double)(this.field_70165_t + (double)radius * 1.5), (double)(this.field_70163_u + (double)radius * 1.5), (double)(this.field_70161_v + (double)radius * 1.5)));
                    for (Entity entity : entities) {
                        if (!(this.func_70032_d(entity) < radius)) continue;
                        ++amount;
                        if (entity instanceof EntityParticle && entity != this) {
                            ((EntityParticle)entity).onParticleSmash(this);
                            this.onParticleSmash((EntityParticle)entity);
                            withParticle = true;
                            continue;
                        }
                        entity.func_70097_a((DamageSource)DamageSourceRadiation.INSTANCE, 3.5f);
                    }
                    if (!withParticle && amount > 1) {
                        this.handleCollisionWithEntity();
                    }
                }
            }
            if (this.field_70173_aa % 2 == 0 && !EntityParticle.canSpawnParticle(this.field_70170_p, flPosX, flPosY, flPosZ)) {
                this.handleCollisionWithEntity();
            }
        } else {
            this.func_70106_y();
        }
    }

    private void onParticleSmash(EntityParticle entityParticle) {
        int radius = (int)((this.getTotalVelocity() + entityParticle.getTotalVelocity()) * 2.5);
        if (!this.field_70170_p.field_72995_K) {
            entityParticle.func_70106_y();
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70173_aa > 20 ? (float)(this.getTotalVelocity() + entityParticle.getTotalVelocity()) * 1.5f : 0.0f, true);
            if (this.getTotalVelocity() + entityParticle.getTotalVelocity() > (double)(ConfigNuclearPhysics.ANTIMATTER_CREATION_SPEED / 2.0f)) {
                this.didCollide = true;
            }
            this.func_70106_y();
        }
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)radius), (double)(this.field_70163_u - (double)radius), (double)(this.field_70161_v - (double)radius), (double)(this.field_70165_t + (double)radius), (double)(this.field_70163_u + (double)radius), (double)(this.field_70161_v + (double)radius));
        for (EntityLivingBase living : this.field_70170_p.func_72872_a(EntityLivingBase.class, bounds)) {
            living.func_70097_a((DamageSource)DamageSourceRadiation.INSTANCE, Math.max(1.0f, (float)radius - living.func_70032_d((Entity)this)));
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(20, (Object)((byte)EnumFacing.SOUTH.ordinal()));
        if (ConfigNuclearPhysics.ENABLE_PARTICLE_CHUNKLOADING && this.updateTicket == null && this.field_70170_p != null) {
            this.updateTicket = ForgeChunkManager.requestTicket((Object)Physica.INSTANCE, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
            if (this.updateTicket != null) {
                this.updateTicket.getModData();
                this.updateTicket.bindEntity((Entity)this);
            }
        }
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.hostLocationX = tag.func_74762_e("tileLocationX");
        this.hostLocationY = tag.func_74762_e("tileLocationY");
        this.hostLocationZ = tag.func_74762_e("tileLocationZ");
        this.movementDirection = Face.getOrientation(tag.func_74771_c("direction"));
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74780_a("tileLocationX", (double)this.hostLocationX);
        tag.func_74780_a("tileLocationY", (double)this.hostLocationY);
        tag.func_74780_a("tileLocationZ", (double)this.hostLocationZ);
        tag.func_74774_a("direction", (byte)this.movementDirection.ordinal());
    }

    public void func_70108_f(Entity entity) {
        if (entity != this) {
            this.handleCollisionWithEntity();
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (ConfigNuclearPhysics.ENABLE_PARTICLE_CHUNKLOADING) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.updateTicket);
        }
    }

    public double turn() {
        Face leftDirection = this.movementDirection.getRelativeSide(Face.WEST);
        Face rightDirection = this.movementDirection.getRelativeSide(Face.EAST);
        Face upDirection = this.movementDirection.getRelativeSide(Face.UP);
        Face downDirection = this.movementDirection.getRelativeSide(Face.DOWN);
        if (this.field_70170_p.func_147437_c((int)Math.floor(this.field_70165_t + (double)leftDirection.offsetX), (int)Math.floor(this.field_70163_u + (double)leftDirection.offsetY), (int)Math.floor(this.field_70161_v + (double)leftDirection.offsetZ))) {
            this.movementDirection = leftDirection;
        } else if (this.field_70170_p.func_147437_c((int)Math.floor(this.field_70165_t + (double)rightDirection.offsetX), (int)Math.floor(this.field_70163_u + (double)rightDirection.offsetY), (int)Math.floor(this.field_70161_v + (double)rightDirection.offsetZ))) {
            this.movementDirection = rightDirection;
        } else if (this.field_70170_p.func_147437_c((int)Math.floor(this.field_70165_t + (double)upDirection.offsetX), (int)Math.floor(this.field_70163_u + (double)upDirection.offsetY), (int)Math.floor(this.field_70161_v + (double)upDirection.offsetZ))) {
            this.movementDirection = upDirection;
        } else if (this.field_70170_p.func_147437_c((int)Math.floor(this.field_70165_t + (double)downDirection.offsetX), (int)Math.floor(this.field_70163_u + (double)downDirection.offsetY), (int)Math.floor(this.field_70161_v + (double)downDirection.offsetZ))) {
            this.movementDirection = downDirection;
        } else {
            this.func_70106_y();
            return 0.0;
        }
        this.func_70107_b(Math.floor(this.field_70165_t) + 0.5, Math.floor(this.field_70163_u) + 0.5, Math.floor(this.field_70161_v) + 0.5);
        return this.getTotalVelocity() * (double)0.9075f;
    }

    private void handleCollisionWithEntity() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)(this.field_70173_aa > 20 ? this.getTotalVelocity() * 2.5 : 0.0), true);
        }
        int radius = (int)(this.getTotalVelocity() * 1.5);
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)radius), (double)(this.field_70163_u - (double)radius), (double)(this.field_70161_v - (double)radius), (double)(this.field_70165_t + (double)radius), (double)(this.field_70163_u + (double)radius), (double)(this.field_70161_v + (double)radius));
        for (EntityLivingBase living : this.field_70170_p.func_72872_a(EntityLivingBase.class, bounds)) {
            living.func_70097_a((DamageSource)DamageSourceRadiation.INSTANCE, Math.max(1.0f, (float)radius - living.func_70032_d((Entity)this)));
        }
        this.func_70106_y();
    }

    public double getTotalVelocity() {
        return Math.abs(this.field_70159_w) + Math.abs(this.field_70181_x) + Math.abs(this.field_70179_y);
    }

    public boolean didCollide() {
        return this.didCollide;
    }
}

