/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.radiation;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.nuclear.common.NuclearBlockRegister;
import physica.nuclear.common.items.armor.ItemHazmatArmor;
import physica.nuclear.common.radiation.RoentgenOverlay;

public class RadiationSystem {
    public static final double toRealRoentgenConversionRate = 713.3316666666666;

    public static void applyRontgenEntity(EntityLivingBase base, float kiloRoentgen, float durationMultiplier, float distanceFromSource, float maxRadius) {
        if (base != null && base.field_70170_p.field_73012_v.nextFloat() < kiloRoentgen) {
            if (base.field_70170_p.field_72995_K) {
                if (base == Minecraft.func_71410_x().field_71439_g) {
                    long worldTime = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_82737_E();
                    int amplifier = (int)((maxRadius - distanceFromSource) / maxRadius * 5.0f - 1.0f);
                    RoentgenOverlay.storeDataValue(worldTime, kiloRoentgen * (float)Math.max(1, amplifier));
                }
            } else {
                float protection = 1.0f;
                distanceFromSource = Math.max(0.5f, distanceFromSource);
                boolean isPlayer = base instanceof EntityPlayer;
                if (isPlayer) {
                    EntityPlayer player = (EntityPlayer)base;
                    if (!player.field_71075_bZ.field_75098_d) {
                        boolean hasArmor = true;
                        for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                            ItemStack armor = player.func_82169_q(i);
                            if (armor == null || !(armor.func_77973_b() instanceof ItemHazmatArmor)) {
                                hasArmor = false;
                                continue;
                            }
                            protection += 1.0f;
                            float damage = kiloRoentgen * 2.15f / ((ItemHazmatArmor)armor.func_77973_b()).getPlatingProtection();
                            if (!(Math.random() < (double)damage)) continue;
                            int integerDamage = (int)(Math.max(1.0, (double)kiloRoentgen * 2.15) / (double)((ItemHazmatArmor)armor.func_77973_b()).getPlatingProtection());
                            if (player.func_82169_q(i).func_77960_j() <= player.func_82169_q(i).func_77958_k() && !player.func_82169_q(i).func_96631_a(integerDamage, base.field_70170_p.field_73012_v)) continue;
                            player.func_70062_b(i + 1, null);
                        }
                        if (hasArmor || protection == 0.0f) {
                            // empty if block
                        }
                    }
                }
                int duration = (int)(durationMultiplier * 20.0f * kiloRoentgen / protection / distanceFromSource);
                int amplifier = (int)((maxRadius - distanceFromSource) / maxRadius * 5.0f - protection);
                if (!(protection < 5.0f && isPlayer && ((EntityPlayer)base).field_71075_bZ.field_75098_d)) {
                    // empty if block
                }
                if (isPlayer && (maxRadius - distanceFromSource) / maxRadius * 75.0f > 0.0f) {
                    EntityPlayer player = (EntityPlayer)base;
                    ItemStack stack = player.field_71071_by.func_70448_g();
                    if (AbstractionLayer.Electricity.isItemElectric(stack)) {
                        int electricity = (int)((float)AbstractionLayer.Electricity.getElectricCapacity(stack) / (1200.0f / (maxRadius - distanceFromSource) / maxRadius * 75.0f));
                        AbstractionLayer.Electricity.extractElectricity(stack, electricity, false);
                    }
                }
            }
        }
    }

    public static void spreadRadioactiveBlock(World world, int x, int y, int z) {
        int currentMeta = world.func_72805_g(x, y, z);
        if (currentMeta > 1) {
            for (Face dir : Face.VALID) {
                int i1 = x + dir.offsetX;
                int j1 = y + dir.offsetY;
                int k1 = z + dir.offsetZ;
                if (currentMeta <= 1) continue;
                if (world.func_147439_a(i1, j1, k1) == Blocks.field_150346_d && world.func_72805_g(i1, j1, k1) == 0) {
                    world.func_147465_d(i1, j1, k1, (Block)NuclearBlockRegister.blockRadioactiveDirt, currentMeta - 1, 3);
                    world.func_72921_c(x, y, z, currentMeta - 1, 3);
                    continue;
                }
                if (world.func_147439_a(i1, j1, k1) == Blocks.field_150349_c && world.func_72805_g(i1, j1, k1) == 0) {
                    world.func_147465_d(i1, j1, k1, (Block)NuclearBlockRegister.blockRadioactiveGrass, currentMeta - 1, 3);
                    world.func_72921_c(x, y, z, currentMeta - 1, 3);
                    continue;
                }
                if (world.func_147439_a(i1, j1, k1) != Blocks.field_150348_b || world.func_72805_g(i1, j1, k1) != 0) continue;
                world.func_72921_c(x, y, z, currentMeta - 1, 3);
                world.func_147465_d(i1, j1, k1, (Block)NuclearBlockRegister.blockRadioactiveStone, currentMeta - 1, 3);
            }
        }
    }
}

