/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.recipe.RecipeSystem;
import physica.library.tile.TileBasePoweredContainer;
import physica.nuclear.client.gui.GuiChemicalBoiler;
import physica.nuclear.common.NuclearFluidRegister;
import physica.nuclear.common.inventory.ContainerChemicalBoiler;
import physica.nuclear.common.recipe.type.ChemicalBoilerRecipe;

public class TileChemicalBoiler
extends TileBasePoweredContainer
implements IGuiInterface,
IFluidHandler {
    public static final int TICKS_REQUIRED = 1400;
    public static final int POWER_USAGE = ElectricityUtilities.convertEnergy(2500, Unit.WATT, Unit.RF);
    public static final int SLOT_ENERGY = 0;
    public static final int SLOT_INPUT1 = 1;
    public static final int SLOT_INPUT2 = 2;
    private static final int[] ACCESSIBLE_SLOTS_UP = new int[]{1, 2};
    private static final int[] ACCESSIBLE_SLOTS_DOWN = new int[]{1};
    protected FluidTank waterTank = new FluidTank(FluidRegistry.WATER, 0, 5000);
    protected FluidTank hexaTank = new FluidTank(NuclearFluidRegister.LIQUID_HE, 0, 5000);
    protected int operatingTicks = 0;

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        if (this.hasEnoughEnergy()) {
            if (this.canProcess()) {
                if (this.operatingTicks < 1400) {
                    ++this.operatingTicks;
                    ItemStack input = this.func_70301_a(2);
                    ChemicalBoilerRecipe recipe2 = (ChemicalBoilerRecipe)RecipeSystem.getRecipe(this.getClass(), input);
                    this.waterTank.drain(recipe2.getWaterUse() / 1400, true);
                } else {
                    this.process();
                    this.operatingTicks = 0;
                }
                this.extractEnergy();
            } else {
                this.operatingTicks = 0;
            }
        }
        this.drainBattery(0);
        ItemStack waterInput = this.func_70301_a(1);
        if (waterInput != null && waterInput.func_77973_b() == Items.field_151131_as && this.waterTank.getCapacity() - this.waterTank.getFluidAmount() >= 1000) {
            this.func_70299_a(1, new ItemStack(Items.field_151133_ar));
            this.waterTank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
        }
    }

    public boolean canProcess() {
        ChemicalBoilerRecipe recipe2;
        ItemStack input = this.func_70301_a(2);
        if (input != null && (recipe2 = (ChemicalBoilerRecipe)RecipeSystem.getRecipe(this.getClass(), input)) != null && recipe2.getWaterUse() / 1400 <= this.waterTank.getFluidAmount()) {
            return this.hexaTank.getFluidAmount() < this.hexaTank.getCapacity();
        }
        return false;
    }

    private void process() {
        ItemStack input = this.func_70301_a(2);
        ChemicalBoilerRecipe recipe2 = (ChemicalBoilerRecipe)RecipeSystem.getRecipe(this.getClass(), input);
        this.hexaTank.fill(new FluidStack(NuclearFluidRegister.LIQUID_HE, recipe2.getHexafluorideGenerated()), true);
        this.func_70298_a(2, 1);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound waterCompound = new NBTTagCompound();
        this.waterTank.writeToNBT(waterCompound);
        NBTTagCompound hexaCompound = new NBTTagCompound();
        this.hexaTank.writeToNBT(hexaCompound);
        nbt.func_74782_a("WaterTank", (NBTBase)waterCompound);
        nbt.func_74782_a("HexaTank", (NBTBase)hexaCompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound waterCompound = (NBTTagCompound)nbt.func_74781_a("WaterTank");
        NBTTagCompound hexaCompound = (NBTTagCompound)nbt.func_74781_a("HexaTank");
        this.waterTank.readFromNBT(waterCompound);
        this.hexaTank.readFromNBT(hexaCompound);
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(this.operatingTicks);
        dataList.add(this.waterTank.writeToNBT(new NBTTagCompound()));
        dataList.add(this.hexaTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        this.operatingTicks = buf.readInt();
        this.waterTank.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.hexaTank.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public int getOperatingTicks() {
        return this.operatingTicks;
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    public FluidTank getHexTank() {
        return this.hexaTank;
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && (slot == 0 ? AbstractionLayer.Electricity.isItemElectric(stack) : (slot == 2 ? RecipeSystem.isRecipeInput(this.getClass(), stack) : slot == 1 && stack.func_77973_b() == Items.field_151131_as));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiChemicalBoiler(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerChemicalBoiler(player, this);
    }

    @Override
    public boolean canConnectElectricity(Face from) {
        return from == this.getFacing().getOpposite() || from == Face.DOWN;
    }

    @Override
    public int getPowerUsage() {
        return POWER_USAGE;
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.UP ? ACCESSIBLE_SLOTS_UP : (face == Face.DOWN ? ACCESSIBLE_SLOTS_DOWN : ACCESSIBLE_SLOTS_NONE);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face face) {
        return slot == 1 && this.func_70301_a(1) != null && this.func_70301_a(1).func_77973_b() == Items.field_151133_ar;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return resource != null && this.canFill(from, resource.getFluid()) ? this.waterTank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return from.ordinal() == this.getFacing().getOpposite().getRelativeSide(Face.EAST).ordinal() ? this.hexaTank.drain(maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER ? from.ordinal() == this.getFacing().getOpposite().getRelativeSide(Face.WEST).ordinal() : fluid == NuclearFluidRegister.LIQUID_HE && from.ordinal() == this.getFacing().getOpposite().getRelativeSide(Face.EAST).ordinal();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == NuclearFluidRegister.LIQUID_HE;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (from.ordinal() == this.getFacing().getOpposite().getRelativeSide(Face.WEST).ordinal()) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.waterTank.getInfo();
        } else if (from.ordinal() == this.getFacing().getOpposite().getRelativeSide(Face.EAST).ordinal()) {
            FluidTankInfo[] fluidTankInfoArray3 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray3;
            fluidTankInfoArray3[0] = this.hexaTank.getInfo();
        } else {
            fluidTankInfoArray = new FluidTankInfo[]{};
        }
        return fluidTankInfoArray;
    }

    public boolean isRotating() {
        return this.getOperatingTicks() > 0;
    }
}

