/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.recipe.RecipeSystem;
import physica.library.tile.TileBasePoweredContainer;
import physica.nuclear.client.gui.GuiChemicalExtractor;
import physica.nuclear.common.inventory.ContainerChemicalExtractor;
import physica.nuclear.common.recipe.type.ChemicalExtractorRecipe;

public class TileChemicalExtractor
extends TileBasePoweredContainer
implements IGuiInterface,
IFluidHandler {
    public static final int TICKS_REQUIRED = 900;
    public static final int POWER_USAGE = ElectricityUtilities.convertEnergy(3500, Unit.WATT, Unit.RF);
    public static final int SLOT_ENERGY = 0;
    public static final int SLOT_INPUT = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int[] ACCESSIBLE_SLOTS_DOWN = new int[]{2};
    private static final int[] ACCESSIBLE_SLOTS_UP = new int[]{1};
    protected FluidTank waterTank = new FluidTank(new FluidStack(FluidRegistry.WATER, 0), 5000);
    protected int operatingTicks = 0;

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        if (this.hasEnoughEnergy()) {
            ItemStack input;
            ItemStack output = this.func_70301_a(2);
            if (this.canProcess(output, input = this.func_70301_a(1))) {
                if (this.operatingTicks < 900) {
                    ++this.operatingTicks;
                } else {
                    this.process(input, output);
                    this.operatingTicks = 0;
                }
                this.extractEnergy();
            } else {
                this.operatingTicks = 0;
            }
        }
        this.drainBattery(0);
        ItemStack input = this.func_70301_a(1);
        if (input != null && input.func_77973_b() == Items.field_151131_as && this.waterTank.getFluidAmount() < this.waterTank.getCapacity()) {
            this.func_70299_a(1, new ItemStack(Items.field_151133_ar));
            this.waterTank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
        }
    }

    public boolean canProcess(ItemStack output, ItemStack input) {
        ChemicalExtractorRecipe recipe2;
        if (input != null && (recipe2 = (ChemicalExtractorRecipe)RecipeSystem.getRecipe(this.getClass(), input)) != null) {
            return this.waterTank.getFluidAmount() > recipe2.getWaterUse() && (output == null || output.func_77973_b() == recipe2.getOutput().func_77973_b() && output.field_77994_a + recipe2.getOutput().field_77994_a <= output.func_77976_d());
        }
        return false;
    }

    private void process(ItemStack input, ItemStack output) {
        ChemicalExtractorRecipe recipe2 = (ChemicalExtractorRecipe)RecipeSystem.getRecipe(this.getClass(), input);
        this.waterTank.drain(recipe2.getWaterUse(), true);
        --input.field_77994_a;
        if (input.field_77994_a <= 0) {
            this.func_70299_a(1, null);
        } else {
            this.func_70299_a(1, input);
        }
        if (output != null) {
            output.field_77994_a += recipe2.getOutput().field_77994_a;
        } else {
            this.func_70299_a(2, new ItemStack(recipe2.getOutput().func_77973_b(), recipe2.getOutput().field_77994_a));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound compound = new NBTTagCompound();
        this.waterTank.writeToNBT(compound);
        nbt.func_74782_a("Tank", (NBTBase)compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound compound = (NBTTagCompound)nbt.func_74781_a("Tank");
        this.waterTank.readFromNBT(compound);
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(this.operatingTicks);
        dataList.add(this.waterTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        this.operatingTicks = buf.readInt();
        this.waterTank.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public int getOperatingTicks() {
        return this.operatingTicks;
    }

    public FluidTank getTank() {
        return this.waterTank;
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 2 && stack != null && (slot == 0 ? AbstractionLayer.Electricity.isItemElectric(stack) : slot == 1 && stack.func_77973_b() == Items.field_151131_as || RecipeSystem.isRecipeInput(this.getClass(), stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiChemicalExtractor(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerChemicalExtractor(player, this);
    }

    @Override
    public int getPowerUsage() {
        return POWER_USAGE;
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.DOWN ? ACCESSIBLE_SLOTS_DOWN : (face == Face.UP ? ACCESSIBLE_SLOTS_UP : ACCESSIBLE_SLOTS_NONE);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face face) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.waterTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.waterTank.getInfo()};
    }
}

