/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import physica.api.core.PhysicaAPI;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.core.common.CoreBlockRegister;
import physica.library.location.GridLocation;
import physica.library.tile.TileBaseContainer;
import physica.nuclear.client.gui.GuiFissionReactor;
import physica.nuclear.common.NuclearBlockRegister;
import physica.nuclear.common.NuclearItemRegister;
import physica.nuclear.common.configuration.ConfigNuclearPhysics;
import physica.nuclear.common.entity.EntityParticle;
import physica.nuclear.common.inventory.ContainerFissionReactor;
import physica.nuclear.common.radiation.RadiationSystem;
import physica.nuclear.common.tile.TileInsertableControlRod;
import physica.nuclear.common.tile.TileReactorControlPanel;
import physica.nuclear.common.tile.TileTurbine;

public class TileFissionReactor
extends TileBaseContainer
implements IGuiInterface {
    public static final int SLOT_INPUT = 0;
    public static final int MELTDOWN_TEMPERATURE = 4407;
    public static final int AIR_TEMPERATURE = 15;
    public static final int WATER_TEMPERATURE = 10;
    public static final int STEAM_GEN_DIAMETER = 5;
    public static final int STEAM_GEN_HEIGHT = 2;
    private static final int[] ACCESSIBLE_SLOTS_UP = new int[]{0};
    private final TileTurbine[][][] cachedTurbines = new TileTurbine[5][2][5];
    protected float temperature = 15.0f;
    protected int surroundingWater;
    boolean isIncased;
    private int insertion;

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        Block[] adjacentBlocks = new Block[Face.VALID.length];
        for (int i = 0; i < adjacentBlocks.length; ++i) {
            Face direction = Face.VALID[i];
            GridLocation loc = this.getLocation();
            adjacentBlocks[i] = this.getWorld().func_147439_a(loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ);
        }
        this.cooldownReactor(adjacentBlocks);
        if (this.hasFuelRod() && !this.isBeingControlled(adjacentBlocks) && ticks > 50) {
            this.processFuelRod();
            if (this.temperature > (float)(4508 + this.getWorld().field_73012_v.nextInt(5)) && this.hasFuelRod()) {
                this.performMeltdown();
            }
        }
    }

    @Override
    public void updateCommon(int ticks) {
        GridLocation loc;
        int radius;
        block14: {
            super.updateCommon(ticks);
            radius = 4;
            loc = this.getLocation();
            if (ticks % 50 == 0) {
                int i;
                this.isIncased = true;
                for (i = -radius; i <= radius; ++i) {
                    for (int k = -radius; k <= radius; ++k) {
                        Block block = this.getWorld().func_147439_a(loc.xCoord + i, loc.yCoord - radius, loc.zCoord + k);
                        if (block == NuclearBlockRegister.blockReactorControlPanel) {
                            TileReactorControlPanel control = (TileReactorControlPanel)this.getWorld().func_147438_o(loc.xCoord + i, loc.yCoord - radius, loc.zCoord + k);
                            if (control != null) {
                                control.reactor = this;
                                GridLocation controlLoc = control.getLocation();
                                this.getWorld().func_147458_c(controlLoc.xCoord, controlLoc.yCoord, controlLoc.zCoord, controlLoc.xCoord, controlLoc.yCoord, controlLoc.zCoord);
                                continue;
                            }
                            this.isIncased = false;
                        } else {
                            if (block == CoreBlockRegister.blockLead) continue;
                            this.isIncased = false;
                        }
                        break block14;
                    }
                }
                block2: for (i = -radius; i <= radius; ++i) {
                    for (int j = -radius + 1; j <= 2; ++j) {
                        for (int k = -radius; k <= radius; ++k) {
                            if (i != -radius && i != radius && k != radius && k != -radius) continue;
                            Block block = this.getWorld().func_147439_a(loc.xCoord + i, loc.yCoord + j, loc.zCoord + k);
                            if (block == NuclearBlockRegister.blockReactorControlPanel) {
                                TileReactorControlPanel control = (TileReactorControlPanel)this.getWorld().func_147438_o(loc.xCoord + i, loc.yCoord + j, loc.zCoord + k);
                                if (control != null) {
                                    control.reactor = this;
                                    GridLocation controlLoc = control.getLocation();
                                    this.getWorld().func_147458_c(controlLoc.xCoord, controlLoc.yCoord, controlLoc.zCoord, controlLoc.xCoord, controlLoc.yCoord, controlLoc.zCoord);
                                    continue;
                                }
                                this.isIncased = false;
                                break block2;
                            }
                            if (block == CoreBlockRegister.blockLead) continue;
                            this.isIncased = false;
                            break block2;
                        }
                    }
                }
            }
        }
        if (!this.isServer() || ticks % 5 == 0) {
            double tempScale = (double)this.temperature / 300.0;
            double dRadius = this.isIncased ? Math.min(tempScale, (double)radius) : tempScale;
            List entities = this.getWorld().func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)((double)loc.xCoord - dRadius), (double)((double)loc.yCoord - dRadius), (double)((double)loc.zCoord - dRadius), (double)((double)loc.xCoord + dRadius + 1.0), (double)((double)loc.yCoord + tempScale), (double)((double)loc.zCoord + dRadius + 1.0)));
            for (Entity entity : entities) {
                if (entity instanceof EntityParticle || !(entity instanceof EntityLivingBase)) continue;
                double scale = (tempScale - entity.func_70011_f((double)loc.xCoord + 0.5, (double)loc.yCoord + 0.5, (double)loc.zCoord + 0.5)) / 3.0;
                RadiationSystem.applyRontgenEntity((EntityLivingBase)entity, (float)scale * 1.5f, (float)scale * 15.0f, (float)entity.func_70011_f((double)loc.xCoord + 0.5, (double)loc.yCoord + 0.5, (double)loc.zCoord + 0.5), (float)tempScale);
            }
        }
        if (ticks % 4 == 0) {
            this.produceSteam();
        }
    }

    private boolean isBeingControlled(Block[] adjacentBlocks) {
        this.insertion = 0;
        GridLocation loc = this.getLocation();
        for (int i = 0; i < adjacentBlocks.length; ++i) {
            TileEntity tile;
            Block block = adjacentBlocks[i];
            Face direction = Face.VALID[i];
            if (block == NuclearBlockRegister.blockControlRod) {
                this.insertion = 100;
                continue;
            }
            if (block == NuclearBlockRegister.blockThermometer) {
                block.func_149674_a(this.getWorld(), loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ, this.getWorld().field_73012_v);
                continue;
            }
            if (block != NuclearBlockRegister.blockInsertableControlRod || !((tile = this.getWorld().func_147438_o(loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ)) instanceof TileInsertableControlRod)) continue;
            TileInsertableControlRod rod = (TileInsertableControlRod)tile;
            this.insertion = rod.getInsertion();
        }
        return false;
    }

    public boolean isHighEnriched() {
        return this.hasFuelRod() && this.func_70301_a(0).func_77973_b() == NuclearItemRegister.itemHighEnrichedFuelCell;
    }

    public boolean isLowEnriched() {
        return this.hasFuelRod() && this.func_70301_a(0).func_77973_b() == NuclearItemRegister.itemLowEnrichedFuelCell;
    }

    public int getInsertion() {
        return this.insertion;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateClient(int ticks) {
        super.updateClient(ticks);
        GridLocation loc = this.getLocation();
        if (this.getWorld().func_72820_D() % 100L == 0L && this.temperature >= 100.0f) {
            this.getWorld().func_72908_a((double)loc.xCoord, (double)loc.yCoord, (double)loc.zCoord, "physicanuclearphysics:block.fission_reactor", Math.min(this.temperature / 100.0f, 1.0f), 1.0f);
        }
        float radius = 0.15f;
        for (int k = 0; k < 4; ++k) {
            float xCoordOffset;
            float outerRods = 0.15f;
            float f = k == 0 ? -outerRods : (xCoordOffset = k == 1 ? outerRods : 0.0f);
            float zCoordOffset = k == 2 ? -outerRods : (k == 3 ? outerRods : 0.0f);
            float i = 0.175f;
            while ((double)i < 0.8) {
                if ((double)this.getWorld().field_73012_v.nextFloat() < (double)((this.temperature - 15.0f) / 13221.0f) / 4.0) {
                    this.getWorld().func_72869_a("reddust", (double)((float)loc.xCoord + xCoordOffset + 0.5f) + this.getWorld().field_73012_v.nextDouble() * (double)radius - (double)(radius / 2.0f), (double)((float)loc.yCoord + i) + this.getWorld().field_73012_v.nextDouble() * (double)radius - (double)(radius / 2.0f), (double)((float)loc.zCoord + zCoordOffset + 0.5f) + this.getWorld().field_73012_v.nextDouble() * (double)radius - (double)(radius / 2.0f), (double)0.01f, (double)0.4f, (double)0.01f);
                }
                i = (float)((double)i + 0.1);
            }
        }
        radius = this.temperature / 300.0f;
        if ((double)radius > 0.5) {
            for (int i = 0; i < (int)(Math.pow(radius, 1.5) / 10.0); ++i) {
                for (int k = 0; k < 4; ++k) {
                    float xCoordOffset;
                    if (!((double)this.getWorld().field_73012_v.nextFloat() < 0.0625)) continue;
                    float outerRods = 0.15f;
                    float f = k == 0 ? -outerRods : (xCoordOffset = k == 1 ? outerRods : 0.0f);
                    float zCoordOffset = k == 2 ? -outerRods : (k == 3 ? outerRods : 0.0f);
                    this.getWorld().func_72869_a("reddust", (double)((float)loc.xCoord + xCoordOffset + 0.5f) + this.getWorld().field_73012_v.nextDouble() * (double)radius - (double)(radius / 2.0f), (double)loc.yCoord + this.getWorld().field_73012_v.nextDouble() * (double)radius - (double)(radius / 2.0f), (double)((float)loc.zCoord + zCoordOffset + 0.5f) + this.getWorld().field_73012_v.nextDouble() * (double)radius - (double)(radius / 2.0f), (double)0.01f, 0.5, (double)0.01f);
                }
            }
        }
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public void performMeltdown() {
        if (PhysicaAPI.isDebugMode) {
            PhysicaAPI.logger.info("Fission reactor had a meltdown at: " + this.getLocation().toString() + ". Reactor stats: temp: " + this.temperature + " insertion: " + this.insertion);
        }
        GridLocation loc = this.getLocation();
        if (ConfigNuclearPhysics.PROTECTED_WORLDS.contains(this.getWorld().func_72912_H().func_76065_j().toLowerCase())) {
            if (PhysicaAPI.isDebugMode) {
                PhysicaAPI.logger.info("World " + this.getWorld().func_72912_H().func_76065_j().toLowerCase() + " is protected so the meltdown did not occur fully.");
            }
            this.getWorld().func_147468_f(loc.xCoord, loc.yCoord, loc.zCoord);
            return;
        }
        this.func_70299_a(0, null);
        GridLocation currentLocation = new GridLocation(loc.xCoord, loc.yCoord, loc.zCoord);
        int size = 10;
        for (int i = -10; i <= 10; ++i) {
            for (int j = -10; j <= 10; ++j) {
                for (int k = -10; k <= 10; ++k) {
                    if (loc.getDistanceSquared(loc.xCoord + i, loc.yCoord + j, loc.zCoord + k) >= 100.0) continue;
                    currentLocation.set(loc.xCoord + i, loc.yCoord + j, loc.zCoord + k);
                    Block block = currentLocation.getBlock((IBlockAccess)this.getWorld());
                    if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
                    currentLocation.setBlockAirNonUpdate(this.getWorld());
                }
            }
        }
        this.getWorld().func_72876_a(null, (double)loc.xCoord, (double)loc.yCoord, (double)loc.zCoord, 10.0f, true);
        this.getWorld().func_147449_b(loc.xCoord, loc.yCoord, loc.zCoord, (Block)NuclearBlockRegister.blockMeltedReactor);
    }

    private void cooldownReactor(Block[] adjacentBlocks) {
        double decrease = (this.temperature - 15.0f) / 3000.0f;
        if (!this.hasFuelRod()) {
            decrease *= 25.0;
        }
        this.surroundingWater = 0;
        for (Block block : adjacentBlocks) {
            if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
            ++this.surroundingWater;
            decrease += (double)((this.temperature - 10.0f) / 20000.0f);
        }
        if (decrease != 0.0) {
            this.temperature = (float)((double)this.temperature - (decrease < 0.001 && decrease > 0.0 ? 0.001 : (decrease > -0.001 && decrease < 0.0 ? -0.001 : decrease)));
        }
    }

    private void processFuelRod() {
        ItemStack fuelRod = this.func_70301_a(0);
        double insertDecimal = (double)(100 - this.insertion) / 100.0;
        if ((double)this.getWorld().field_73012_v.nextFloat() < insertDecimal) {
            fuelRod.func_77964_b(fuelRod.func_77960_j() + 1 + Math.round(this.temperature / 2203.0f));
        }
        if (this.isHighEnriched()) {
            if (fuelRod.func_77960_j() >= fuelRod.func_77958_k()) {
                this.func_70299_a(0, new ItemStack((Item)NuclearItemRegister.itemLowEnrichedFuelCell, 1, (int)((float)(NuclearItemRegister.itemLowEnrichedFuelCell.func_77612_l() / 3) + this.getWorld().field_73012_v.nextFloat() * (float)(NuclearItemRegister.itemLowEnrichedFuelCell.func_77612_l() / 5))));
            }
            this.temperature = (float)((double)this.temperature + (4407.0 * insertDecimal * (double)(1.25f + this.getWorld().field_73012_v.nextFloat() / 5.0f) - (double)this.temperature) / (double)(200 + 20 * this.surroundingWater));
        } else if (this.isLowEnriched()) {
            if (fuelRod.func_77960_j() >= fuelRod.func_77958_k()) {
                this.func_70299_a(0, null);
            }
            this.temperature = (float)((double)this.temperature + (4407.0 * insertDecimal * (double)(0.25f + this.getWorld().field_73012_v.nextFloat() / 5.0f) - (double)this.temperature) / (double)(200 + 20 * this.surroundingWater));
        }
        this.temperature = Math.max(15.0f, this.temperature);
    }

    private void produceSteam() {
        if (this.temperature <= 100.0f) {
            return;
        }
        GridLocation loc = this.getLocation();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5; ++k) {
                    boolean isFaceWater;
                    boolean isReactor2d;
                    boolean bl = isReactor2d = i - 2 == 0 && k - 2 == 0;
                    if (isReactor2d && j == 0) continue;
                    int offsetX = loc.xCoord + i - 2;
                    int offsetY = loc.yCoord + j;
                    int offsetZ = loc.zCoord + k - 2;
                    Block offset = this.getWorld().func_147439_a(offsetX, offsetY, offsetZ);
                    if (offset != Blocks.field_150355_j) continue;
                    boolean bl2 = isFaceWater = this.getWorld().func_147439_a(offsetX, loc.yCoord, loc.zCoord) == Blocks.field_150355_j || this.getWorld().func_147439_a(loc.xCoord, loc.yCoord, offsetZ) == Blocks.field_150355_j || isReactor2d;
                    if (!isFaceWater) continue;
                    if (this.isServer()) {
                        float temperatureVarient = this.temperature / 4407.0f / 2400.0f;
                        if ((double)this.getWorld().field_73012_v.nextFloat() < (double)(temperatureVarient / 2.0f) + (double)temperatureVarient * Math.pow(this.temperature / 4407.0f, 250.0)) {
                            this.getWorld().func_147468_f(offsetX, offsetY, offsetZ);
                            continue;
                        }
                        TileTurbine turbine = this.cachedTurbines[i][j][k];
                        if (turbine == null || !this.getWorld().field_147482_g.contains(turbine)) {
                            TileEntity above = this.getWorld().func_147438_o(offsetX, offsetY + 1, offsetZ);
                            if (above instanceof TileTurbine) {
                                this.cachedTurbines[i][j][k] = (TileTurbine)above;
                                turbine = (TileTurbine)above;
                            } else {
                                this.cachedTurbines[i][j][k] = null;
                                turbine = null;
                            }
                        }
                        if (turbine == null) continue;
                        turbine.addSteam((int)((this.temperature - 100.0f) / 10.0f * 0.65f) * 20 * 20);
                        continue;
                    }
                    if (!this.isClient() || !(this.getWorld().field_73012_v.nextFloat() < this.temperature / 4407.0f)) continue;
                    if (this.getWorld().field_73012_v.nextInt(80) == 0) {
                        this.getWorld().func_72908_a((double)offsetX + 0.5, (double)offsetY + 0.5, (double)offsetZ + 0.5, "liquid.lava", 0.5f, 2.1f + (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.85f);
                    }
                    if (this.getWorld().field_73012_v.nextInt(40) == 0) {
                        this.getWorld().func_72908_a((double)offsetX + 0.5, (double)offsetY + 0.5, (double)offsetZ + 0.5, "liquid.lavapop", 0.5f, 2.6f + (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.8f);
                    }
                    double offsetFX = (double)offsetX + this.getWorld().field_73012_v.nextDouble() / 2.0 * (double)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
                    double offsetFY = (double)offsetY + this.getWorld().field_73012_v.nextDouble() / 2.0 * (double)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
                    double offsetFZ = (double)offsetZ + this.getWorld().field_73012_v.nextDouble() / 2.0 * (double)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
                    this.getWorld().func_72869_a("bubble", offsetFX + 0.5, offsetFY + (double)0.2f, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                    if (this.getWorld().field_73012_v.nextInt(3) != 0) continue;
                    this.getWorld().func_72869_a("smoke", offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean hasFuelRod() {
        return this.func_70301_a(0) != null && (this.func_70301_a(0).func_77973_b() == NuclearItemRegister.itemHighEnrichedFuelCell || this.func_70301_a(0).func_77973_b() == NuclearItemRegister.itemLowEnrichedFuelCell);
    }

    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(Float.valueOf(this.temperature));
        dataList.add(this.insertion);
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        this.temperature = buf.readFloat();
        this.insertion = buf.readInt();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("Temperature", this.temperature);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.temperature = nbt.func_74760_g("Temperature");
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && slot == 0 && (stack.func_77973_b() == NuclearItemRegister.itemHighEnrichedFuelCell || stack.func_77973_b() == NuclearItemRegister.itemLowEnrichedFuelCell);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiFissionReactor(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerFissionReactor(player, this);
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.UP ? ACCESSIBLE_SLOTS_UP : ACCESSIBLE_SLOTS_NONE;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face FACE) {
        return true;
    }
}

