/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import physica.api.core.abstraction.Face;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.location.GridLocation;
import physica.library.tile.TileBasePoweredContainer;
import physica.nuclear.common.NuclearBlockRegister;
import physica.nuclear.common.NuclearItemRegister;

public class TileFusionReactor
extends TileBasePoweredContainer {
    public static final float PLASMA_SPAWN_STRENGTH = 13.0f;
    public static final int MAX_DEUTERIUM = 1024;
    public static final int SLOT_DEUTERIUM = 0;
    public static final int SLOT_TRITIUM = 1;
    public static final int POWER_USAGE = ElectricityUtilities.convertEnergy(175000, Unit.WATT, Unit.RF);
    private static final int[] ACCESSIBLE_SLOTS_UP = new int[]{0, 1};
    private int energyStored;
    private int ticksRunning;
    private boolean isRunning = false;

    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        ItemStack deuterium = this.func_70301_a(0);
        ItemStack tritium = this.func_70301_a(1);
        if (this.hasEnoughEnergy() && deuterium != null && deuterium.field_77994_a > 0 && tritium != null && tritium.field_77994_a > 0) {
            ++this.ticksRunning;
            if (this.ticksRunning % 300 == 0) {
                --deuterium.field_77994_a;
                --tritium.field_77994_a;
            }
            this.isRunning = true;
            this.extractEnergy();
            if (ticks % 2 != 0) {
                return;
            }
            GridLocation loc = this.getLocation();
            for (Face direction : Face.VALID) {
                Block block;
                if (direction == Face.DOWN || direction == Face.UP || (block = this.getWorld().func_147439_a(loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ)).func_149688_o() != Material.field_151579_a && block.func_149688_o() != Material.field_151581_o) continue;
                NuclearBlockRegister.blockPlasma.spawn(this.getWorld(), block, loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ, 10);
            }
        } else {
            this.isRunning = false;
            if (this.ticksRunning >= 10000) {
                this.ticksRunning = 0;
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Energy", this.energyStored);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStored = nbt.func_74762_e("Energy");
    }

    @Override
    public void writeSynchronizationPacket(List<Object> dataList, EntityPlayer player) {
        super.writeSynchronizationPacket(dataList, player);
        dataList.add(this.energyStored);
        dataList.add(this.isRunning);
        dataList.add(this.func_70301_a(0) != null ? this.func_70301_a((int)0).field_77994_a : 0);
        dataList.add(this.func_70301_a(1) != null ? this.func_70301_a((int)1).field_77994_a : 0);
    }

    @Override
    public void readSynchronizationPacket(ByteBuf buf, EntityPlayer player) {
        int size;
        super.readSynchronizationPacket(buf, player);
        this.energyStored = buf.readInt();
        this.isRunning = buf.readBoolean();
        if (this.func_70301_a(0) != null) {
            this.func_70301_a((int)0).field_77994_a = buf.readInt();
        } else {
            size = buf.readInt();
            if (size > 0) {
                this.func_70299_a(0, new ItemStack((Item)NuclearItemRegister.itemDeuteriumCell, size));
            }
        }
        if (this.func_70301_a(1) != null) {
            this.func_70301_a((int)1).field_77994_a = buf.readInt();
        } else {
            size = buf.readInt();
            if (size > 0) {
                this.func_70299_a(1, new ItemStack((Item)NuclearItemRegister.itemTritiumCell, size));
            }
        }
    }

    @Override
    public boolean canConnectElectricity(Face from) {
        return from != Face.UP;
    }

    @Override
    public int getPowerUsage() {
        return POWER_USAGE;
    }

    @Override
    public int func_70297_j_() {
        return 1024;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        ItemStack slotStack = this.func_70301_a(slot);
        if (slot == 0 && stack != null && stack.func_77973_b() == NuclearItemRegister.itemDeuteriumCell) {
            if (slotStack != null) {
                if (slotStack.field_77994_a + stack.field_77994_a <= this.func_70297_j_()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (slot == 1 && stack != null && stack.func_77973_b() == NuclearItemRegister.itemTritiumCell) {
            if (slotStack != null) {
                return slotStack.field_77994_a + stack.field_77994_a <= this.func_70297_j_();
            }
            return true;
        }
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.UP ? ACCESSIBLE_SLOTS_UP : ACCESSIBLE_SLOTS_NONE;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face face) {
        return true;
    }

    public int func_70302_i_() {
        return 2;
    }
}

