/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.location.GridLocation;
import physica.library.tile.TileBasePoweredContainer;
import physica.nuclear.client.gui.GuiCentrifuge;
import physica.nuclear.common.NuclearFluidRegister;
import physica.nuclear.common.NuclearItemRegister;
import physica.nuclear.common.inventory.ContainerCentrifuge;
import physica.nuclear.common.tile.TileChemicalBoiler;

public class TileGasCentrifuge
extends TileBasePoweredContainer
implements IGuiInterface,
IFluidHandler {
    public static final int TICKS_REQUIRED = 2400;
    public static final int SLOT_ENERGY = 0;
    public static final int POWER_USAGE = ElectricityUtilities.convertEnergy(3000, Unit.WATT, Unit.RF);
    public static final int SLOT_OUTPUT1 = 1;
    public static final int SLOT_OUTPUT2 = 2;
    private static final int[] ACCESSIBLE_SLOTS_DOWN = new int[]{1, 2};
    protected FluidTank tank = new FluidTank(new FluidStack(NuclearFluidRegister.LIQUID_HE, 0), 5000);
    protected int operatingTicks = 0;

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        if (this.hasEnoughEnergy()) {
            if (this.canProcess()) {
                if (this.operatingTicks < 2400) {
                    ++this.operatingTicks;
                } else {
                    this.process();
                    this.operatingTicks = 0;
                }
                this.extractEnergy();
            }
            Face direction = this.getFacing().getOpposite();
            GridLocation loc = this.getLocation();
            TileEntity tile = this.getWorld().func_147438_o(loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ);
            if (tile instanceof TileChemicalBoiler) {
                TileChemicalBoiler boiler = (TileChemicalBoiler)tile;
                if (boiler.hexaTank.getFluidAmount() > 0 && this.tank.getFluidAmount() < this.tank.getCapacity()) {
                    this.tank.fill(boiler.hexaTank.drain(Math.min(10, boiler.hexaTank.getFluidAmount()), true), true);
                }
            }
            this.drainBattery(0);
        } else {
            this.drainBattery(0);
            this.operatingTicks = 0;
        }
    }

    public boolean canProcess() {
        if (this.func_70301_a(1) != null && this.func_70301_a((int)1).field_77994_a == this.func_70301_a(1).func_77976_d()) {
            return false;
        }
        if (this.func_70301_a(2) != null && this.func_70301_a((int)2).field_77994_a == this.func_70301_a(2).func_77976_d()) {
            return false;
        }
        return this.tank.getFluid() != null && this.tank.getFluid().getFluid() == NuclearFluidRegister.LIQUID_HE && this.tank.getFluidAmount() >= 2500;
    }

    private void process() {
        this.tank.drain(2500, true);
        boolean isEnriched = this.getWorld().field_73012_v.nextFloat() > 0.828f;
        int slot = isEnriched ? 1 : 2;
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            ++itemStack.field_77994_a;
            this.func_70299_a(slot, itemStack);
        } else {
            this.func_70299_a(slot, new ItemStack((Item)(isEnriched ? NuclearItemRegister.itemUranium235 : NuclearItemRegister.itemUranium238)));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound compound = new NBTTagCompound();
        this.tank.writeToNBT(compound);
        nbt.func_74782_a("Tank", (NBTBase)compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound compound = (NBTTagCompound)nbt.func_74781_a("Tank");
        this.tank.readFromNBT(compound);
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(this.operatingTicks);
        dataList.add(this.tank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        this.operatingTicks = buf.readInt();
        this.tank.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public int getOperatingTicks() {
        return this.operatingTicks;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && slot == 0 && AbstractionLayer.Electricity.isItemElectric(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiCentrifuge(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerCentrifuge(player, this);
    }

    @Override
    public boolean canConnectElectricity(Face from) {
        return from == Face.DOWN || from == Face.UP;
    }

    @Override
    public int getPowerUsage() {
        return POWER_USAGE;
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face side) {
        return side == Face.DOWN ? ACCESSIBLE_SLOTS_DOWN : ACCESSIBLE_SLOTS_NONE;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face side) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face side) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from.ordinal() == this.getFacing().getOpposite().ordinal() && fluid == NuclearFluidRegister.LIQUID_HE;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.ordinal() == this.getFacing().getOpposite().ordinal() && fluid == NuclearFluidRegister.LIQUID_HE;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (from.ordinal() == this.getFacing().getOpposite().ordinal()) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.tank.getInfo();
        } else {
            fluidTankInfoArray = new FluidTankInfo[]{};
        }
        return fluidTankInfoArray;
    }
}

