/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.library.inventory.ContainerBase;
import physica.library.location.GridLocation;
import physica.library.network.IPacket;
import physica.library.network.netty.PacketSystem;
import physica.library.network.packet.PacketTile;
import physica.library.tile.TileBaseRotateable;
import physica.nuclear.client.gui.GuiInsertableControlRod;
import physica.nuclear.common.tile.TileFissionReactor;

public class TileInsertableControlRod
extends TileBaseRotateable
implements IGuiInterface {
    public static final int CONTROL_ROD_PACKET_ID = 8;
    private int insertion = 100;

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(1.0, 1.0, 1.0);
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        Face facing = this.getFacing().getOpposite();
        GridLocation loc = this.getLocation();
        TileEntity tile = this.getWorld().func_147438_o(loc.xCoord + facing.offsetX, loc.yCoord + facing.offsetY, loc.zCoord + facing.offsetZ);
        if (!(tile instanceof TileFissionReactor)) {
            this.getWorld().func_72838_d((Entity)new EntityItem(this.getWorld(), (double)loc.xCoord + 0.5, (double)loc.yCoord + 0.5, (double)loc.zCoord + 0.5, new ItemStack(this.func_145838_q())));
            this.getLocation().setBlockAir(this.getWorld());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiInsertableControlRod(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerBase<TileInsertableControlRod>(player, this, null);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("insertion", this.insertion);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.insertion = tag.func_74762_e("insertion");
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(this.insertion);
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        this.insertion = buf.readInt();
    }

    @Override
    public void writeSynchronizationPacket(List<Object> dataList, EntityPlayer player) {
        super.writeSynchronizationPacket(dataList, player);
        dataList.add(this.insertion);
    }

    @Override
    public void readSynchronizationPacket(ByteBuf buf, EntityPlayer player) {
        super.readSynchronizationPacket(buf, player);
        this.insertion = buf.readInt();
    }

    public int getInsertion() {
        return this.insertion;
    }

    public void actionPerformed(int amount, Side side) {
        if (side == Side.CLIENT) {
            GridLocation loc = this.getLocation();
            PacketSystem.INSTANCE.sendToServer(new PacketTile("", 8, loc.xCoord, loc.yCoord, loc.zCoord, amount));
        }
        this.insertion = Math.max(0, Math.min(100, this.insertion + amount));
    }

    @Override
    public void readCustomPacket(int id, EntityPlayer player, Side side, IPacket type) {
        if (id == 8 && side.isServer() && type instanceof PacketTile) {
            this.actionPerformed(((PacketTile)type).customInteger, side);
        }
    }
}

