/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import physica.library.location.GridLocation;
import physica.library.tile.TileBase;
import physica.nuclear.common.NuclearBlockRegister;
import physica.nuclear.common.radiation.RadiationSystem;

public class TileMeltedReactor
extends TileBase {
    public static final float RADIATION_RADIUS = 30.0f;
    public static final float RADIATION_PARTICLES = 10.0f;
    public static final float START_RADIATION = 4.383E7f;
    public int radiation = 43830000;
    public int temperature = 6000;

    @Override
    public void updateServer(int ticks) {
        Block block;
        int z;
        int y;
        int x;
        double distance;
        double z2;
        double d5;
        double y2;
        double d4;
        double d3;
        double x2;
        super.updateServer(ticks);
        GridLocation loc = this.getLocation();
        if (ticks % 10 == 0 && this.getWorld().func_147439_a(loc.xCoord, loc.yCoord - 1, loc.zCoord).func_149688_o().func_76222_j()) {
            this.getWorld().func_147468_f(loc.xCoord, loc.yCoord, loc.zCoord);
            this.getWorld().func_147449_b(loc.xCoord, loc.yCoord - 1, loc.zCoord, (Block)NuclearBlockRegister.blockMeltedReactor);
            TileEntity entity = this.getWorld().func_147438_o(loc.xCoord, loc.yCoord, loc.zCoord);
            if (entity instanceof TileMeltedReactor) {
                TileMeltedReactor tile = (TileMeltedReactor)entity;
                tile.radiation = this.radiation;
                tile.temperature = this.temperature;
            }
            return;
        }
        if (this.temperature > 0) {
            --this.temperature;
            x2 = (double)loc.xCoord + 0.5 + (this.getWorld().field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            d3 = (double)loc.xCoord - x2;
            distance = MathHelper.func_76133_a((double)(d3 * d3 + (d4 = (double)loc.yCoord - (y2 = (double)loc.yCoord + 0.5 + (this.getWorld().field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0)) * d4 + (d5 = (double)loc.zCoord - (z2 = (double)loc.zCoord + 0.5 + (this.getWorld().field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0)) * d5));
            if (distance <= 30.0 && this.getWorld().field_73012_v.nextDouble() > distance / 30.0) {
                x = (int)Math.floor(x2);
                y = (int)Math.floor(y2);
                z = (int)Math.floor(z2);
                block = this.getWorld().func_147439_a(x, y, z);
                if (block.func_149688_o() == Material.field_151579_a) {
                    if (this.getWorld().func_147439_a(x, y - 1, z).func_149688_o() != Material.field_151579_a) {
                        this.getWorld().func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
                    }
                } else if (block == Blocks.field_150348_b) {
                    if (this.temperature < 2100) {
                        this.getWorld().func_147465_d(x, y, z, (Block)NuclearBlockRegister.blockRadioactiveStone, (int)Math.min(15.0, 30.0 - distance), 3);
                    } else {
                        this.getWorld().func_147449_b(x, y, z, Blocks.field_150347_e);
                    }
                } else if (block == Blocks.field_150347_e) {
                    this.getWorld().func_147449_b(x, y, z, Blocks.field_150353_l);
                } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                    this.getWorld().func_147468_f(x, y, z);
                } else if (block == Blocks.field_150354_m) {
                    this.getWorld().func_147449_b(x, y, z, Blocks.field_150359_w);
                }
            }
        }
        if (this.radiation > 0) {
            --this.radiation;
            x2 = (double)loc.xCoord + 0.5 + (this.getWorld().field_73012_v.nextDouble() - 0.5) * 30.0 * (double)((float)this.radiation / 4.383E7f) * 2.0;
            d3 = (double)loc.xCoord - x2;
            distance = MathHelper.func_76133_a((double)(d3 * d3 + (d4 = (double)loc.yCoord - (y2 = Math.min(255.0, Math.max(0.0, (double)loc.yCoord + 0.5 + (this.getWorld().field_73012_v.nextDouble() - 0.5) * 30.0 * (double)((float)this.radiation / 4.383E7f) * 2.0)))) * d4 + (d5 = (double)loc.zCoord - (z2 = (double)loc.zCoord + 0.5 + (this.getWorld().field_73012_v.nextDouble() - 0.5) * 30.0 * (double)((float)this.radiation / 4.383E7f) * 2.0)) * d5));
            if (distance <= 30.0 && this.getWorld().field_73012_v.nextDouble() > distance / 30.0) {
                x = (int)Math.floor(x2);
                y = (int)Math.floor(y2);
                z = (int)Math.floor(z2);
                block = this.getWorld().func_147439_a(x, y, z);
                if (block == Blocks.field_150349_c) {
                    this.getWorld().func_147465_d(x, y, z, (Block)NuclearBlockRegister.blockRadioactiveGrass, (int)Math.min(15.0, 30.0 - distance), 3);
                } else if (block == Blocks.field_150346_d) {
                    this.getWorld().func_147465_d(x, y, z, (Block)NuclearBlockRegister.blockRadioactiveDirt, (int)Math.min(15.0, 30.0 - distance), 3);
                }
            }
        }
    }

    @Override
    public void updateCommon(int ticks) {
        super.updateCommon(ticks);
        if (this.radiation > 0) {
            GridLocation loc = this.getLocation();
            List entities = this.getWorld().func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((float)loc.xCoord - 30.0f), (double)((float)loc.yCoord - 30.0f), (double)((float)loc.zCoord - 30.0f), (double)((float)loc.xCoord + 30.0f), (double)((float)loc.yCoord + 30.0f), (double)((float)loc.zCoord + 30.0f)));
            for (EntityLivingBase entity : entities) {
                double scale = 30.0 - entity.func_70011_f((double)loc.xCoord + 0.5, (double)loc.yCoord + 0.5, (double)loc.zCoord + 0.5);
                RadiationSystem.applyRontgenEntity(entity, (float)(scale / 1.75) * ((float)this.radiation / 4.383E7f), (float)scale * 2.0f, (float)entity.func_70011_f((double)loc.xCoord + 0.5, (double)loc.yCoord + 0.5, (double)loc.zCoord + 0.5), 30.0f);
            }
        }
    }

    @Override
    public void updateClient(int ticks) {
        super.updateClient(ticks);
        int i = 0;
        GridLocation loc = this.getLocation();
        do {
            double x2 = (double)loc.xCoord + 0.5 + (this.getWorld().field_73012_v.nextDouble() - 0.5) * 30.0 * 2.0;
            double y2 = (double)loc.yCoord + 0.5 + (this.getWorld().field_73012_v.nextDouble() - 0.5) * 30.0 * 2.0;
            double z2 = (double)loc.zCoord + 0.5 + (this.getWorld().field_73012_v.nextDouble() - 0.5) * 30.0 * 2.0;
            double d3 = (double)loc.xCoord - x2;
            double d4 = (double)loc.yCoord - y2;
            double d5 = (double)loc.zCoord - z2;
            double distance = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
            if (!(this.getWorld().field_73012_v.nextDouble() > distance / 30.0)) continue;
            this.getWorld().func_72869_a("reddust", x2, y2, z2, (double)0.01f, 1.0, (double)0.01f);
            ++i;
        } while (!((float)i > 30.0f));
    }

    @Override
    public void writeSynchronizationPacket(List<Object> dataList, EntityPlayer player) {
        super.writeSynchronizationPacket(dataList, player);
        dataList.add(this.radiation);
    }

    @Override
    public void readSynchronizationPacket(ByteBuf buf, EntityPlayer player) {
        super.readSynchronizationPacket(buf, player);
        this.radiation = buf.readInt();
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("radiation", this.radiation);
        tag.func_74768_a("heatTime", this.temperature);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.radiation = tag.func_74762_e("radiation");
        this.temperature = tag.func_74762_e("heatTime");
    }
}

