/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.library.location.GridLocation;
import physica.library.tile.TileBaseContainer;
import physica.nuclear.client.gui.GuiNeutronCaptureChamber;
import physica.nuclear.common.NuclearItemRegister;
import physica.nuclear.common.inventory.ContainerNeutronCaptureChamber;
import physica.nuclear.common.tile.TileFissionReactor;

public class TileNeutronCaptureChamber
extends TileBaseContainer
implements IGuiInterface {
    public static final int TICKS_REQUIRED = 2847;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    private static final int[] ACCESSIBLE_SLOTS_UP = new int[]{0};
    private static final int[] ACCESSIBLE_SLOTS_DOWN = new int[]{1};
    protected float operatingTicks = 0.0f;
    private boolean hasDeuterium;

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        if (this.canProcess()) {
            this.hasDeuterium = true;
            if (this.operatingTicks < 2847.0f) {
                this.operatingTicks += this.getTicksAddition();
            } else {
                this.process();
                this.operatingTicks = 0.0f;
            }
        } else {
            this.hasDeuterium = false;
        }
    }

    private float getTicksAddition() {
        Face facing = this.getFacing().getOpposite();
        GridLocation loc = this.getLocation();
        TileFissionReactor reactor = (TileFissionReactor)this.getWorld().func_147438_o(loc.xCoord + facing.offsetX, loc.yCoord + facing.offsetY, loc.zCoord + facing.offsetZ);
        return reactor.temperature / 2847.0f;
    }

    public boolean canProcess() {
        Face facing = this.getFacing().getOpposite();
        GridLocation loc = this.getLocation();
        TileEntity tile = this.getWorld().func_147438_o(loc.xCoord + facing.offsetX, loc.yCoord + facing.offsetY, loc.zCoord + facing.offsetZ);
        if (tile instanceof TileFissionReactor) {
            if (this.func_70301_a(0) == null || this.func_70301_a(1) != null && this.func_70301_a((int)1).field_77994_a >= this.func_70297_j_()) {
                return this.operatingTicks > 0.0f;
            }
            TileFissionReactor reactor = (TileFissionReactor)tile;
            return reactor.hasFuelRod() && reactor.temperature > 1000.0f;
        }
        this.getWorld().func_72838_d((Entity)new EntityItem(this.getWorld(), (double)loc.xCoord + 0.5, (double)loc.yCoord + 0.5, (double)loc.zCoord + 0.5, new ItemStack(this.func_145838_q())));
        this.getLocation().setBlockAir(this.getWorld());
        return false;
    }

    private void process() {
        ItemStack output = this.func_70301_a(1);
        if (this.func_70301_a(0) == null) {
            return;
        }
        --this.func_70301_a((int)0).field_77994_a;
        if (this.func_70301_a((int)0).field_77994_a <= 0) {
            this.func_70299_a(0, null);
        }
        if (output != null) {
            ++output.field_77994_a;
        } else {
            this.func_70299_a(1, new ItemStack((Item)NuclearItemRegister.itemTritiumCell));
        }
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(Float.valueOf(this.operatingTicks));
        dataList.add(this.hasDeuterium);
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        this.operatingTicks = buf.readFloat();
        this.hasDeuterium = buf.readBoolean();
    }

    public float getOperatingTicks() {
        return this.operatingTicks;
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && stack != null && stack.func_77973_b() == NuclearItemRegister.itemDeuteriumCell;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiNeutronCaptureChamber(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerNeutronCaptureChamber(player, this);
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.DOWN ? ACCESSIBLE_SLOTS_DOWN : (face == Face.UP ? ACCESSIBLE_SLOTS_UP : ACCESSIBLE_SLOTS_DOWN);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face face) {
        return true;
    }

    public boolean hasDeuterium() {
        return this.hasDeuterium;
    }
}

