/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.api.nuclear.IElectromagnet;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.location.GridLocation;
import physica.library.tile.TileBasePoweredContainer;
import physica.nuclear.client.gui.GuiParticleAccelerator;
import physica.nuclear.common.NuclearItemRegister;
import physica.nuclear.common.configuration.ConfigNuclearPhysics;
import physica.nuclear.common.entity.EntityParticle;
import physica.nuclear.common.inventory.ContainerParticleAccelerator;

public class TileParticleAccelerator
extends TileBasePoweredContainer
implements IGuiInterface,
IElectromagnet {
    public static final int SLOT_INPUTCELLS = 0;
    public static final int SLOT_INPUTMATTER = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int POWER_USAGE = ElectricityUtilities.convertEnergy(340000, Unit.WATT, Unit.RF);
    private static final int[] ACCESSIBLE_SLOTS_UP = new int[]{1};
    private static final int[] ACCESSIBLE_SLOTS_DOWN = new int[]{2};
    private static final int[] ACCESSIBLE_SLOTS_MIDDLE_SIDES = new int[]{0};
    protected EntityParticle particle = null;
    protected long currentSessionUse = 0L;
    protected int currentSessionTicks = 0;
    protected double velocity = 0.0;
    protected int antimatterAmount = 0;
    private Item lastInput;
    private int idleTicks;

    public static void main(String[] args) {
        double speed = 0.001;
        double travelled = 0.5;
        int ticks = 0;
        int stopped = 0;
        while (speed < 1.0) {
            if ((int)(travelled += (speed += 0.002)) % 50 == 49) {
                speed *= (double)0.9075f;
                if (++stopped > 32) {
                    System.out.println("Never hit a max.");
                    break;
                }
            }
            if (speed > 1.0) break;
            ++ticks;
        }
        System.out.println("Corner hits: " + stopped + ", Speed: " + speed + ", Ticks: " + ticks + ", Seconds: " + ticks / 20 + ", Travelled: " + travelled);
    }

    public void onChunkUnload() {
        if (this.particle != null) {
            this.particle.func_70106_y();
            this.particle = null;
            this.velocity = 0.0;
            this.currentSessionUse = 0L;
        }
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        ItemStack stackMatter = this.func_70301_a(1);
        ItemStack stackEmptyCell = this.func_70301_a(0);
        ItemStack stackOutputSlot = this.func_70301_a(2);
        if (stackMatter != null) {
            if (stackMatter.func_77973_b() != this.lastInput) {
                this.lastInput = stackMatter.func_77973_b();
            }
        } else {
            this.lastInput = null;
        }
        if (this.idleTicks > 0) {
            --this.idleTicks;
            return;
        }
        if (this.particle != null) {
            if (this.hasEnoughEnergy() && this.isPoweredByRedstone()) {
                this.velocity = this.particle.getTotalVelocity();
                if (stackEmptyCell != null && stackEmptyCell.func_77973_b() == NuclearItemRegister.itemEmptyElectromagneticCell && this.antimatterAmount >= 125) {
                    if (stackOutputSlot != null) {
                        if (stackOutputSlot.func_77973_b() == NuclearItemRegister.itemAntimatterCell125Milligram) {
                            this.func_70298_a(0, 1);
                            this.antimatterAmount -= 125;
                            ++stackOutputSlot.field_77994_a;
                        }
                    } else {
                        this.func_70298_a(0, 1);
                        this.func_70299_a(2, new ItemStack((Item)NuclearItemRegister.itemAntimatterCell125Milligram));
                    }
                }
                if (this.currentSessionUse + 1L == Long.MAX_VALUE) {
                    this.currentSessionUse = 1L;
                }
                ++this.currentSessionTicks;
                this.currentSessionUse += (long)this.extractEnergy();
                if (this.particle.field_70128_L) {
                    if (this.particle.didCollide() && stackEmptyCell != null && stackEmptyCell.func_77973_b() == NuclearItemRegister.itemEmptyQuantumCell) {
                        if (this.getWorld().field_73012_v.nextFloat() > 0.666f) {
                            this.antimatterAmount = (int)Math.min(1000.0f, (float)this.antimatterAmount + (float)(7 + this.getWorld().field_73012_v.nextInt(5)) * (this.getParticleVelocity() / ConfigNuclearPhysics.ANTIMATTER_CREATION_SPEED));
                            this.particle.func_70106_y();
                        }
                        if (this.antimatterAmount > 100) {
                            if (stackOutputSlot != null) {
                                if (stackOutputSlot.func_77973_b() == NuclearItemRegister.itemDarkmatterCell) {
                                    this.func_70298_a(0, 1);
                                    this.antimatterAmount = 0;
                                    ++stackOutputSlot.field_77994_a;
                                }
                            } else {
                                this.func_70298_a(0, 1);
                                this.antimatterAmount = 0;
                                this.func_70299_a(2, new ItemStack((Item)NuclearItemRegister.itemDarkmatterCell));
                            }
                        }
                    }
                    this.particle = null;
                    this.velocity = 0.0;
                } else if (this.velocity >= (double)ConfigNuclearPhysics.ANTIMATTER_CREATION_SPEED) {
                    this.antimatterAmount = (int)Math.min(1000.0f, (float)this.antimatterAmount + (float)(7 + this.getWorld().field_73012_v.nextInt(5)) * (this.getParticleVelocity() / ConfigNuclearPhysics.ANTIMATTER_CREATION_SPEED));
                    this.particle.func_70106_y();
                    this.particle = null;
                    this.velocity = 0.0;
                }
            } else {
                this.particle.func_70106_y();
                this.particle = null;
                this.velocity = 0.0;
                this.currentSessionUse = 0L;
                this.currentSessionTicks = 0;
                if (!this.hasEnoughEnergy()) {
                    this.idleTicks = 80;
                }
            }
        } else if (this.isPoweredByRedstone() && this.hasEnoughEnergy()) {
            Face opposite = this.getFacing().getOpposite();
            GridLocation loc = this.getLocation();
            if (stackMatter != null && stackEmptyCell != null && EntityParticle.canSpawnParticle(this.getWorld(), loc.xCoord + opposite.offsetX, loc.yCoord + opposite.offsetY, loc.zCoord + opposite.offsetZ)) {
                this.currentSessionUse = this.extractEnergy();
                this.particle = new EntityParticle(this.getWorld(), loc.xCoord + opposite.offsetX, loc.yCoord + opposite.offsetY, loc.zCoord + opposite.offsetZ, opposite);
                this.getWorld().func_72838_d((Entity)this.particle);
                this.func_70298_a(1, 1);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateClient(int ticks) {
        super.updateClient(ticks);
        if (this.particle != null && this.particle.field_70128_L) {
            this.particle = null;
        }
    }

    public AcceleratorStatus getAcceleratorStatus() {
        if (this.particle != null) {
            if (this.hasEnoughEnergy() && this.isPoweredByRedstone()) {
                if (this.particle.field_70128_L) {
                    if (this.particle.didCollide()) {
                        return AcceleratorStatus.Done;
                    }
                    return AcceleratorStatus.Failure;
                }
                if (this.velocity > (double)ConfigNuclearPhysics.ANTIMATTER_CREATION_SPEED) {
                    return AcceleratorStatus.Done;
                }
                return AcceleratorStatus.Accelerating;
            }
            return AcceleratorStatus.Failure;
        }
        if (this.isPoweredByRedstone() && this.hasEnoughEnergy()) {
            Face opposite = this.getFacing().getOpposite();
            GridLocation loc = this.getLocation();
            if (EntityParticle.canSpawnParticle(this.getWorld(), loc.xCoord + opposite.offsetX, loc.yCoord + opposite.offsetY, loc.zCoord + opposite.offsetZ)) {
                return AcceleratorStatus.Ready;
            }
            return AcceleratorStatus.Failure;
        }
        if (!this.hasEnoughEnergy()) {
            return AcceleratorStatus.Disabled;
        }
        return AcceleratorStatus.Idle;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.particle != null) {
            this.particle.func_70106_y();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("currentSessionUse", this.currentSessionUse);
        nbt.func_74768_a("currentSessionTicks", this.currentSessionTicks);
        nbt.func_74768_a("antimatterAmount", this.antimatterAmount);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentSessionUse = nbt.func_74763_f("currentSessionUse");
        this.currentSessionTicks = nbt.func_74762_e("currentSessionTicks");
        this.antimatterAmount = nbt.func_74762_e("antimatterAmount");
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(this.currentSessionUse);
        dataList.add(this.currentSessionTicks);
        dataList.add(this.antimatterAmount);
        dataList.add(this.velocity);
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        this.currentSessionUse = buf.readLong();
        this.currentSessionTicks = buf.readInt();
        this.antimatterAmount = buf.readInt();
        this.velocity = buf.readDouble();
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && slot != 2 && (slot == 1 && stack.func_77985_e() || slot == 0 && (stack.func_77973_b() == NuclearItemRegister.itemEmptyElectromagneticCell || stack.func_77973_b() == NuclearItemRegister.itemEmptyQuantumCell));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiParticleAccelerator(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerParticleAccelerator(player, this);
    }

    @Override
    public boolean canConnectElectricity(Face from) {
        return from != this.getFacing().getOpposite();
    }

    @Override
    public int getPowerUsage() {
        return POWER_USAGE;
    }

    public float getParticleVelocity() {
        return (float)this.velocity;
    }

    public long getSessionUse() {
        return this.currentSessionUse;
    }

    public int getCurrentSessionTicks() {
        return this.currentSessionTicks;
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.DOWN ? ACCESSIBLE_SLOTS_DOWN : (face == Face.UP ? ACCESSIBLE_SLOTS_UP : ACCESSIBLE_SLOTS_MIDDLE_SIDES);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face face) {
        return slot == 2;
    }

    public int getAntimatterAmount() {
        return this.antimatterAmount;
    }

    public EntityParticle getParticle() {
        return this.particle;
    }

    public void setParticle(EntityParticle particle) {
        this.particle = particle;
    }

    public static enum AcceleratorStatus {
        Disabled("No Power"),
        Idle("Idle"),
        Accelerating("Accelerating"),
        Done("Done"),
        Ready("Ready"),
        Failure("Failure");

        private final String str;

        private AcceleratorStatus(String str) {
            this.str = str;
        }

        public String getDisplayString() {
            return this.str;
        }
    }
}

