/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import physica.api.core.abstraction.Face;
import physica.api.nuclear.IElectromagnet;
import physica.library.location.GridLocation;
import physica.library.tile.TileBase;
import physica.nuclear.common.NuclearBlockRegister;
import physica.nuclear.common.configuration.ConfigNuclearPhysics;
import physica.nuclear.common.effect.damage.DamageSourcePlasma;
import physica.nuclear.common.tile.TileTurbine;

public class TilePlasma
extends TileBase {
    public static final int TARGET_TEMPERATURE = 4407;
    public int strength = ConfigNuclearPhysics.PLASMA_STRENGTH;

    public static boolean canPlace(Block block, World world, int x, int y, int z) {
        if (block == NuclearBlockRegister.blockFusionReactor) {
            return false;
        }
        if (block.func_149739_a().toLowerCase().contains("conduit")) {
            return false;
        }
        return block.func_149712_f(world, x, y, z) != -1.0f && !(block instanceof IElectromagnet);
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        GridLocation loc = this.getLocation();
        if (ticks == 20) {
            if (this.isServer()) {
                if (ConfigNuclearPhysics.PROTECTED_WORLDS.contains(this.getWorld().func_72912_H().func_76065_j().toLowerCase())) {
                    this.getWorld().func_147449_b(loc.xCoord, loc.yCoord, loc.zCoord, Blocks.field_150350_a);
                    return;
                }
                int power = Math.max(this.strength - 1, 0);
                if (power == 0) {
                    this.getWorld().func_147449_b(loc.xCoord, loc.yCoord, loc.zCoord, (Block)Blocks.field_150480_ab);
                    return;
                }
                float directions = 1.0f;
                ArrayList<Face> directionsList = new ArrayList<Face>(Arrays.asList(Face.VALID));
                Collections.shuffle(directionsList);
                for (Face direction : directionsList) {
                    Block block;
                    if (!(this.getWorld().field_73012_v.nextFloat() < directions) || !TilePlasma.canPlace(block = this.getWorld().func_147439_a(loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ), this.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord)) continue;
                    directions -= 0.16666667f;
                    this.getWorld().func_147465_d(loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ, (Block)NuclearBlockRegister.blockPlasma, 0, 3);
                    TileEntity tile = this.getWorld().func_147438_o(loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ);
                    if (!(tile instanceof TilePlasma)) continue;
                    int newPower = power + this.getWorld().field_73012_v.nextInt(2) - 1;
                    ((TilePlasma)tile).strength = (int)((float)newPower / Math.max(1.0f, block.func_149712_f(this.getWorld(), loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ)));
                }
            }
        } else if (ticks > 20 && ticks > this.strength * 5 && this.getWorld().field_73012_v.nextFloat() < 0.333f) {
            this.getWorld().func_147449_b(loc.xCoord, loc.yCoord, loc.zCoord, (Block)(this.getWorld().field_73012_v.nextFloat() < 0.025f ? Blocks.field_150480_ab : Blocks.field_150350_a));
        }
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(loc.xCoord - 1), (double)(loc.yCoord - 1), (double)(loc.zCoord - 1), (double)(loc.xCoord + 2), (double)(loc.yCoord + 2), (double)(loc.zCoord + 2));
        List entitiesNearby = this.getWorld().func_72872_a(Entity.class, bounds);
        for (Entity entity : entitiesNearby) {
            entity.func_70097_a((DamageSource)DamageSourcePlasma.INSTANCE, (float)(10.0 / entity.func_70011_f((double)loc.xCoord + 0.5, (double)loc.yCoord + 0.5, (double)loc.zCoord + 0.5)));
        }
        for (Face direction : Face.VALID) {
            TileEntity tileAboveWater;
            Block blockAboveMagnet;
            if (direction.ordinal() <= 0 || this.getWorld().func_147439_a(loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ) != NuclearBlockRegister.blockElectromagnet || (blockAboveMagnet = this.getWorld().func_147439_a(loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY + 1, loc.zCoord + direction.offsetZ)) != Blocks.field_150355_j || !((tileAboveWater = this.getWorld().func_147438_o(loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY + 2, loc.zCoord + direction.offsetZ)) instanceof TileTurbine)) continue;
            TileTurbine turbine = (TileTurbine)tileAboveWater;
            float temperature = 2783.0684f;
            int steam = (int)temperature * (this.getWorld().func_72805_g(loc.xCoord + direction.offsetX, loc.yCoord + direction.offsetY, loc.zCoord + direction.offsetZ) > 1 ? 60 : 10);
            if (steam <= 0) continue;
            turbine.addSteam(steam);
        }
    }
}

