/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.tile.TileBasePoweredContainer;
import physica.nuclear.client.gui.GuiQuantumAssembler;
import physica.nuclear.common.NuclearItemRegister;
import physica.nuclear.common.configuration.ConfigNuclearPhysics;
import physica.nuclear.common.inventory.ContainerQuantumAssembler;

public class TileQuantumAssembler
extends TileBasePoweredContainer
implements IGuiInterface {
    public static final int SLOT_INPUT = 6;
    public static final int SLOT_OUTPUT = 7;
    public static final int POWER_USAGE = ElectricityUtilities.convertEnergy(256000, Unit.WATT, Unit.RF);
    private static final int TICKS_REQUIRED = ConfigNuclearPhysics.QUANTUM_ASSEMBLER_TICKS_REQUIRED;
    private static final int[] ACCESSIBLE_SLOTS_UP = new int[]{6};
    private static final int[] ACCESSIBLE_SLOTS_DOWN = new int[]{7};
    private static final int[] ACCESSIBLE_SLOTS_ELSE = new int[]{0, 1, 2, 3, 4, 5};
    protected int operatingTicks = 0;
    protected int ticksRequired = TICKS_REQUIRED;
    protected EntityItem entityItem = null;

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return slot == 6 ? !this.isRestricted(itemStack) : slot != 7 && itemStack.func_77973_b() == NuclearItemRegister.itemDarkmatterCell;
    }

    public boolean canProcess() {
        ItemStack itemStack = this.func_70301_a(6);
        if (this.isRestricted(itemStack)) {
            return false;
        }
        for (int i = 0; i <= 5; ++i) {
            ItemStack itemStackInSlot = this.func_70301_a(i);
            if (itemStackInSlot == null) {
                return false;
            }
            if (itemStackInSlot.func_77973_b() == NuclearItemRegister.itemDarkmatterCell) continue;
            return false;
        }
        ItemStack output = this.func_70301_a(7);
        return itemStack == null || output == null || output.field_77994_a < output.func_77976_d();
    }

    public boolean isRestricted(ItemStack itemStack) {
        return itemStack == null || itemStack.field_77994_a <= 0 || itemStack.func_77973_b() == NuclearItemRegister.itemDarkmatterCell || ConfigNuclearPhysics.FLIP_BLACKLIST_TO_WHITELIST != ConfigNuclearPhysics.QUANTUM_ASSEMBLER_BLACKLIST.contains(itemStack.func_77977_a());
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        if (this.canProcess() && this.hasEnoughEnergy()) {
            if (this.operatingTicks < TICKS_REQUIRED) {
                ++this.operatingTicks;
            } else {
                this.process();
                this.operatingTicks = 0;
            }
            this.extractEnergy();
        } else if (this.func_70301_a(6) == null || !this.canProcess()) {
            this.operatingTicks = 0;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateClient(int ticks) {
        super.updateClient(ticks);
        ItemStack itemStack = this.func_70301_a(6);
        if (itemStack != null) {
            if (this.entityItem == null || !itemStack.func_77969_a(this.entityItem.func_92059_d())) {
                this.entityItem = this.getEntityForItem(itemStack);
            }
        } else {
            this.entityItem = null;
        }
    }

    private EntityItem getEntityForItem(ItemStack itemStack) {
        EntityItem entityItem = new EntityItem(this.getWorld(), 0.0, 0.0, 0.0, itemStack.func_77946_l());
        entityItem.func_70288_d();
        return entityItem;
    }

    private void process() {
        for (int i = 0; i <= 5; ++i) {
            ItemStack itemStackInSlot = this.func_70301_a(i);
            itemStackInSlot.func_77964_b(itemStackInSlot.func_77960_j() + 1);
            if (itemStackInSlot.func_77960_j() < itemStackInSlot.func_77958_k()) continue;
            this.func_70298_a(i, 1);
        }
        ItemStack output = this.func_70301_a(7);
        ItemStack input = this.func_70301_a(6);
        if (output != null) {
            if (input != null && input.func_77942_o()) {
                ItemStack clone = input.func_77946_l();
                clone.field_77990_d = null;
                if (ItemStack.func_77989_b((ItemStack)clone, (ItemStack)output)) {
                    this.func_70296_d();
                    ++output.field_77994_a;
                }
            }
        } else if (input != null) {
            ItemStack clone = input.func_77946_l();
            clone.field_77990_d = null;
            clone.field_77994_a = 1;
            this.func_70299_a(7, clone);
        }
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(this.operatingTicks);
        dataList.add(this.ticksRequired);
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        this.operatingTicks = buf.readInt();
        this.ticksRequired = buf.readInt();
    }

    public EntityItem getEntityItem() {
        return this.entityItem;
    }

    public int getOperatingTicks() {
        return this.operatingTicks;
    }

    public int getTicksRequired() {
        return this.ticksRequired;
    }

    @Override
    public boolean canConnectElectricity(Face from) {
        return from.equals((Object)Face.DOWN) || from.equals((Object)Face.UP);
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.UP ? ACCESSIBLE_SLOTS_UP : (face != Face.DOWN ? ACCESSIBLE_SLOTS_ELSE : ACCESSIBLE_SLOTS_DOWN);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    public int func_70302_i_() {
        return 8;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiQuantumAssembler(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerQuantumAssembler(player, this);
    }

    @Override
    public int getPowerUsage() {
        return POWER_USAGE;
    }
}

