/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.electricity.IElectricityProvider;
import physica.api.core.inventory.IGuiInterface;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.location.GridLocation;
import physica.library.tile.TileBaseContainer;
import physica.library.util.OreDictionaryUtilities;
import physica.nuclear.client.gui.GuiRadioisotopeGenerator;
import physica.nuclear.common.inventory.ContainerRadioisotopeGenerator;

public class TileRadioisotopeGenerator
extends TileBaseContainer
implements IGuiInterface,
IElectricityProvider {
    public static final int SLOT_INPUT = 0;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0};
    private final TileEntity[] cachedOutputs = new TileEntity[2];
    public int generate;

    @Override
    public boolean canConnectElectricity(Face from) {
        return from.ordinal() < 2;
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        int n = this.generate = this.func_70301_a(0) == null ? 0 : this.func_70301_a((int)0).field_77994_a * (ElectricityUtilities.convertEnergy(64, Unit.WATT, Unit.RF) / this.func_70297_j_());
        if (this.generate > 0) {
            int index;
            int validReceivers = 0;
            for (index = 0; index < this.cachedOutputs.length; ++index) {
                TileEntity cachedOutput = this.cachedOutputs[index];
                Face out = Face.getOrientation(index);
                if (cachedOutput == null || cachedOutput.func_145837_r()) {
                    cachedOutput = null;
                    GridLocation loc = this.getLocation();
                    TileEntity outputTile = this.getWorld().func_147438_o(loc.xCoord + out.offsetX, loc.yCoord + out.offsetY, loc.zCoord + out.offsetZ);
                    if (AbstractionLayer.Electricity.isElectricReceiver(outputTile)) {
                        this.cachedOutputs[index] = outputTile;
                    }
                }
                if (cachedOutput == null || !AbstractionLayer.Electricity.canConnectElectricity(cachedOutput, out.getOpposite())) continue;
                ++validReceivers;
            }
            if (validReceivers > 0) {
                index = 0;
                for (TileEntity cachedOutput : this.cachedOutputs) {
                    Face out = Face.getOrientation(index);
                    if (AbstractionLayer.Electricity.canConnectElectricity(cachedOutput, out.getOpposite())) {
                        AbstractionLayer.Electricity.receiveElectricity(cachedOutput, out.getOpposite(), this.generate / validReceivers, false);
                    }
                    ++index;
                }
            }
        }
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(this.generate);
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        this.generate = buf.readInt();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return OreDictionaryUtilities.isSameOre(stack, "oreUranium") || OreDictionaryUtilities.isSameOre(stack, "oreUraniumPhysica");
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.UP || face == Face.DOWN ? ACCESSIBLE_SLOTS : ACCESSIBLE_SLOTS_NONE;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack item, Face face) {
        return (face == Face.UP || face == Face.DOWN) && this.func_94041_b(slot, item);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack item, Face face) {
        return face == Face.UP || face == Face.DOWN;
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiRadioisotopeGenerator(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerRadioisotopeGenerator(player, this);
    }

    @Override
    public int getElectricityStored(Face from) {
        return this.generate;
    }

    @Override
    public int extractElectricity(Face from, int maxExtract, boolean simulate) {
        return from == this.getFacing().getOpposite() ? this.getElectricityStored(from) : 0;
    }

    @Override
    public int getElectricCapacity(Face from) {
        return ElectricityUtilities.convertEnergy(640, Unit.WATT, Unit.RF);
    }
}

