/*
 * Decompiled with CFR 0.152.
 */
package physica.nuclear.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.electricity.IElectricityProvider;
import physica.library.location.GridLocation;
import physica.library.tile.TileBase;
import physica.nuclear.common.configuration.ConfigNuclearPhysics;

public class TileTurbine
extends TileBase
implements IElectricityProvider {
    public static final int MAX_STEAM = 3000000;
    public int delayGeneration = 10;
    public TileEntity receiver = null;
    public boolean clientSpin = false;
    protected int energyStored;
    protected int lastEnergyStored;
    protected boolean isGenerating = false;
    protected int steam;
    protected GridLocation mainLocation = new GridLocation();
    protected boolean hasMain = false;
    protected boolean isMain = false;

    public AxisAlignedBB getRenderBoundingBox() {
        return this.isMain ? super.getRenderBoundingBox().func_72314_b(1.0, 1.0, 1.0) : (this.hasMain ? AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0) : super.getRenderBoundingBox());
    }

    public void attemptConstruct() {
        int j;
        int i;
        boolean canConstruct = true;
        int radius = 1;
        GridLocation loc = this.getLocation();
        block0: for (i = -radius; i <= radius && canConstruct; ++i) {
            for (j = -radius; j <= radius; ++j) {
                if (i == 0 && j == 0) continue;
                TileEntity tile = this.getWorld().func_147438_o(loc.xCoord + i, loc.yCoord, loc.zCoord + j);
                if (!(tile instanceof TileTurbine)) {
                    canConstruct = false;
                    continue block0;
                }
                TileTurbine turbine = (TileTurbine)tile;
                if (!turbine.hasMain()) continue;
                canConstruct = false;
                continue block0;
            }
        }
        if (canConstruct) {
            this.isMain = true;
            for (i = -radius; i <= radius; ++i) {
                for (j = -radius; j <= radius; ++j) {
                    ((TileTurbine)this.getWorld().func_147438_o(loc.xCoord + i, loc.yCoord, loc.zCoord + j)).addToConstruction(this);
                }
            }
        }
    }

    public void tryDeconstruct() {
        if (this.isMain) {
            GridLocation loc = this.getLocation();
            int radius = 1;
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    TileEntity tile;
                    if (i == 0 && j == 0 || !((tile = this.getWorld().func_147438_o(loc.xCoord + i, loc.yCoord, loc.zCoord + j)) instanceof TileTurbine)) continue;
                    TileTurbine turbine = (TileTurbine)tile;
                    turbine.hasMain = false;
                    this.mainLocation.set(0, 0, 0);
                }
            }
            this.isMain = false;
            this.hasMain = false;
            this.mainLocation.set(0, 0, 0);
        } else if (this.hasMain) {
            TileTurbine main = (TileTurbine)this.mainLocation.getTile((IBlockAccess)this.getWorld());
            if (main != null) {
                main.tryDeconstruct();
            }
            this.hasMain = false;
            this.mainLocation.set(0, 0, 0);
        }
    }

    protected void addToConstruction(TileTurbine main) {
        this.mainLocation.set(main.getLocation());
        this.hasMain = true;
    }

    public boolean hasMain() {
        return this.hasMain;
    }

    public boolean isMain() {
        return this.isMain;
    }

    @Override
    public void updateServer(int ticks) {
        if (this.hasMain && !this.isMain) {
            return;
        }
        if (this.clientSpin) {
            if (this.delayGeneration > 0) {
                --this.delayGeneration;
            } else {
                this.clientSpin = false;
                this.delayGeneration = 60;
            }
        }
        this.isGenerating = this.energyStored > this.lastEnergyStored || this.steam > 0;
        this.lastEnergyStored = this.energyStored;
        if (this.steam > 0) {
            float steamToRf = ConfigNuclearPhysics.TURBINE_STEAM_TO_RF_RATIO;
            this.energyStored = (int)Math.min((double)this.getElectricCapacity(Face.UNKNOWN), (double)this.energyStored + (double)this.steam * (this.isMain ? (double)steamToRf * 1.111 : (double)steamToRf));
            this.steam = Math.max(this.steam - Math.max(75, this.steam), 0);
            this.clientSpin = true;
            this.delayGeneration = 60;
        }
        GridLocation loc = this.getLocation();
        if (this.receiver == null || this.receiver.func_145837_r()) {
            TileEntity above;
            if (this.receiver != null && this.receiver.func_145837_r()) {
                this.receiver = null;
            }
            if (AbstractionLayer.Electricity.isElectricReceiver(above = this.getWorld().func_147438_o(loc.xCoord, loc.yCoord + 1, loc.zCoord))) {
                this.receiver = above;
            }
        } else {
            this.energyStored -= AbstractionLayer.Electricity.receiveElectricity(this.receiver, Face.DOWN, this.energyStored, false);
        }
        if (this.getWorld().func_72820_D() % 20L == 0L && this.isGenerating && (!this.hasMain || this.isMain)) {
            this.getWorld().func_72908_a((double)loc.xCoord, (double)loc.yCoord, (double)loc.zCoord, "physicanuclearphysics:block.turbine", this.isMain ? 0.75f : 0.1f, 1.0f);
        }
    }

    @Override
    public int getSyncRate() {
        return 10;
    }

    @Override
    public void writeSynchronizationPacket(List<Object> dataList, EntityPlayer player) {
        super.writeSynchronizationPacket(dataList, player);
        dataList.add(this.steam);
        dataList.add(this.isGenerating);
        dataList.add(this.clientSpin);
        dataList.add(this.hasMain);
        dataList.add(this.isMain);
        dataList.add(this.mainLocation.xCoord);
        dataList.add(this.mainLocation.yCoord);
        dataList.add(this.mainLocation.zCoord);
    }

    @Override
    public void readSynchronizationPacket(ByteBuf buf, EntityPlayer player) {
        super.readSynchronizationPacket(buf, player);
        this.steam = buf.readInt();
        this.isGenerating = buf.readBoolean();
        this.clientSpin = buf.readBoolean();
        this.hasMain = buf.readBoolean();
        this.isMain = buf.readBoolean();
        this.mainLocation.set(buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public boolean canConnectElectricity(Face from) {
        return from == Face.UP && !this.hasMain || this.isMain;
    }

    @Override
    public int extractElectricity(Face from, int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energyStored, Math.min(this.getElectricCapacity(from), maxExtract));
        this.energyStored -= simulate ? 0 : energyExtracted;
        int radius = 1;
        if (this.isMain) {
            GridLocation loc = this.getLocation();
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    TileEntity tile;
                    if (i == 0 && j == 0 || !((tile = this.getWorld().func_147438_o(loc.xCoord + i, loc.yCoord, loc.zCoord + j)) instanceof TileTurbine)) continue;
                    TileTurbine turbine = (TileTurbine)tile;
                    energyExtracted += turbine.extractElectricity(from, maxExtract, simulate);
                }
            }
        }
        return (int)((float)energyExtracted * (this.isMain ? 1.15f : 1.0f));
    }

    @Override
    public int getElectricityStored(Face from) {
        TileEntity tile;
        if (!this.isMain && this.hasMain && (tile = this.mainLocation.getTile((IBlockAccess)this.getWorld())) instanceof TileTurbine) {
            return ((TileTurbine)tile).energyStored;
        }
        return this.energyStored;
    }

    @Override
    public int getElectricCapacity(Face from) {
        return (int)(!this.isMain && !this.hasMain ? (double)(3000000.0f * ConfigNuclearPhysics.TURBINE_STEAM_TO_RF_RATIO) : (double)(2.7E7f * ConfigNuclearPhysics.TURBINE_STEAM_TO_RF_RATIO) * 1.111);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStored = nbt.func_74762_e("Energy");
        this.steam = nbt.func_74762_e("Steam");
        this.hasMain = nbt.func_74767_n("hasMain");
        this.isMain = nbt.func_74767_n("isMain");
        this.mainLocation.readFromNBT(nbt, "main");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Energy", this.energyStored);
        nbt.func_74768_a("Steam", this.steam);
        nbt.func_74757_a("hasMain", this.hasMain);
        nbt.func_74757_a("isMain", this.isMain);
        this.mainLocation.writeToNBT(nbt, "main");
    }

    public void addSteam(int steam) {
        TileEntity tile;
        this.steam = Math.min(3000000, this.steam + steam);
        if (!this.isMain && this.hasMain && (tile = this.mainLocation.getTile((IBlockAccess)this.getWorld())) instanceof TileTurbine) {
            ((TileTurbine)tile).steam = Math.min(3000000, ((TileTurbine)tile).steam + this.steam);
            ((TileTurbine)tile).energyStored = Math.min(((TileTurbine)tile).getElectricCapacity(Face.UNKNOWN), ((TileTurbine)tile).energyStored + this.energyStored);
            this.steam = 0;
            this.energyStored = 0;
        }
    }

    public boolean isGenerating() {
        return this.isGenerating;
    }

    public boolean hasClientSpin() {
        return this.clientSpin;
    }

    public int getSteam() {
        return this.steam;
    }
}

