/*
 * Decompiled with CFR 0.152.
 */
package putils.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.InputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import putils.network.PacketChangeState;

public class PacketHandler {
    public static String channelName = "PowerUtils";
    private static FMLEventChannel channel;

    public PacketHandler() {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelName);
        channel.register((Object)this);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        this.onPacketData((InputStream)new ByteBufInputStream(event.packet.payload()), (EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.onPacketData((InputStream)new ByteBufInputStream(event.packet.payload()), null);
    }

    public void onPacketData(InputStream is, EntityPlayer player) {
        DataInputStream data = new DataInputStream(is);
        try {
            byte packetId = data.readByte();
            switch (packetId) {
                case 0: {
                    PacketChangeState packetCHS = new PacketChangeState();
                    packetCHS.readData(data);
                    packetCHS.execute(player);
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static FMLProxyPacket makePacket(byte[] data) {
        return new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])data), channelName);
    }

    public static void sendPacket(byte[] data) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            channel.sendToServer(PacketHandler.makePacket(data));
        } else {
            channel.sendToAll(PacketHandler.makePacket(data));
        }
    }

    public static void sendPacket(byte[] data, EntityPlayerMP player) {
        channel.sendTo(PacketHandler.makePacket(data), player);
    }
}

