/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.fx;

import codechicken.lib.render.TextureUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Iterator;
import mrtjp.projectred.core.libmc.fx.CoreParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class ParticleManagement {
    public static String name = "pr-fx";
    private final ArrayList<CoreParticle> particles = new ArrayList();
    private final ArrayList<CoreParticle> particleQueue = new ArrayList();
    public static final ParticleManagement instance = new ParticleManagement();

    public CoreParticle spawn(World world, String name, double x, double y, double z) {
        if (!world.field_72995_K) {
            return null;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 2) {
            return null;
        }
        CoreParticle particle = new CoreParticle(world, x, y, z);
        particle.setTextureByName(name);
        this.addEffect(particle);
        return particle;
    }

    public void addEffect(CoreParticle effect) {
        this.particleQueue.add(effect);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.render(event.partialTicks);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.particles.clear();
        this.particleQueue.clear();
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.updateParticles();
        }
    }

    private void updateParticles() {
        Minecraft.func_71410_x().field_71424_I.func_76320_a(name + "-update");
        this.particles.addAll(this.particleQueue);
        this.particleQueue.clear();
        Iterator<CoreParticle> it = this.particles.iterator();
        while (it.hasNext()) {
            EntityFX particle = it.next();
            particle.func_70071_h_();
            if (!particle.field_70128_L) continue;
            it.remove();
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private void render(float partialTicks) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a(name + "-render");
        EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
        EntityFX.field_70556_an = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        EntityFX.field_70554_ao = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        EntityFX.field_70555_ap = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        TextureUtils.bindAtlas((int)1);
        this.renderStandardParticles(partialTicks);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private void renderStandardParticles(float partialTicks) {
        float rotationX = ActiveRenderInfo.field_74588_d;
        float rotationZ = ActiveRenderInfo.field_74586_f;
        float rotationYZ = ActiveRenderInfo.field_74587_g;
        float rotationXY = ActiveRenderInfo.field_74596_h;
        float rotationXZ = ActiveRenderInfo.field_74589_e;
        GL11.glPushAttrib((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glDisable((int)32826);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (CoreParticle particle : this.particles) {
            tessellator.func_78380_c(particle.func_70070_b(partialTicks));
            particle.func_70539_a(tessellator, partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
        }
        tessellator.func_78381_a();
        GL11.glPopAttrib();
    }
}

