/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.ulysses.client.gui.watcher;

import by.fxg.basicfml.math.TimeSince;
import by.fxg.ulysses.Ulysses;
import by.fxg.ulysses.client.ClientProxy;
import by.fxg.ulysses.client.utils.IntegrationDrawableButton;
import by.fxg.ulysses.common.inventory.ContainerInventoryWatch;
import by.fxg.ulysses.common.network.PacketInventoryWatch_ChangeGuiType;
import by.fxg.ulysses.common.player.InventoryToolsCache;
import by.fxg.ulysses.common.player.UlyssesPlayerData;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiInventoryWatch
extends GuiContainer {
    private static final ResourceLocation GUI_DRAWABLE_ICONS = new ResourceLocation("ulysses:gui/inventoryicons.png");
    private static final ResourceLocation DRAWABLE_CLICK_SOUND = new ResourceLocation("gui.button.press");
    private static final String PREFIX_ONLINE = "[\u041e\u043d\u043b\u0430\u0439\u043d] ";
    private static final String PREFIX_OFFLINE = "[\u041e\u0444\u0444\u043b\u0430\u0439\u043d] ";
    private ResourceLocation guiTexture = ClientProxy.NO_TEXTURE;
    private String guiTitle = "\u041a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440";
    private int drawablesX;
    private int drawablesY;
    private int drawablesOffset;
    private TimeSince drawableClickCooldown = new TimeSince();
    protected final int inventoryTypeIndex;
    protected final InventoryToolsCache adminData;
    protected final boolean editModeEnabled;
    private static final List<IntegrationDrawableButton> buttonsRegistry = new ArrayList<IntegrationDrawableButton>(){
        {
            this.add(new IntegrationDrawableButton("inventory", 0, 0, 0));
            this.add(new IntegrationDrawableButton("enderchest", 1, 0, 10));
        }
    };

    public GuiInventoryWatch(int inventoryTypeIndex, EntityPlayer playerAdmin, boolean editModeEnabled, ContainerInventoryWatch container) {
        super((Container)container);
        this.inventoryTypeIndex = inventoryTypeIndex;
        this.adminData = UlyssesPlayerData.get((EntityPlayer)playerAdmin).inventoryToolsCache;
        this.editModeEnabled = editModeEnabled;
    }

    protected void setupGui(String guiTitle, int drawablesX, int drawablesY, int drawablesOffset, ResourceLocation guiTexture) {
        this.guiTitle = guiTitle;
        this.drawablesX = drawablesX;
        this.drawablesY = drawablesY;
        this.drawablesOffset = drawablesOffset;
        this.guiTexture = guiTexture;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.drawableClickCooldown.increase();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String dimensionID = String.valueOf(this.adminData.watchedDimensionID);
        this.field_146289_q.func_78276_b(this.adminData.watchedDimensionName, this.field_146999_f - 5 - this.field_146289_q.func_78256_a(this.adminData.watchedDimensionName), 6, 0xAAAAAA);
        this.field_146289_q.func_78276_b(dimensionID, this.field_146999_f - 5 - this.field_146289_q.func_78256_a(dimensionID), 17, 0xAAAAAA);
        String playerStatus = this.adminData.watchedUserOnlineStatus ? PREFIX_ONLINE : PREFIX_OFFLINE;
        this.field_146289_q.func_78276_b(this.guiTitle, 19, 6, 0x404040);
        this.field_146289_q.func_78276_b(playerStatus, 19, 17, 0x404040);
        this.field_146289_q.func_78276_b(this.adminData.watchedUsername, this.field_146289_q.func_78256_a(playerStatus) + 19, 17, 0x404040);
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawVerticalDrawableButtons();
    }

    protected void drawVerticalDrawableButtons() {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_DRAWABLE_ICONS);
        for (int i = 0; i != buttonsRegistry.size(); ++i) {
            IntegrationDrawableButton drawable = buttonsRegistry.get(i);
            if (drawable == null) continue;
            drawable.draw(Tessellator.field_78398_a, this.inventoryTypeIndex == drawable.inventoryTypeIndex, this.field_147003_i + this.drawablesX, this.field_147009_r + this.drawablesY + i * this.drawablesOffset);
        }
    }

    protected void func_73864_a(int x, int y, int buttonID) {
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null && buttonID == 0 && this.drawableClickCooldown.isOver(9L)) {
            for (int i = 0; i != buttonsRegistry.size(); ++i) {
                IntegrationDrawableButton drawable = buttonsRegistry.get(i);
                int posX = this.field_147003_i + this.drawablesX;
                int posY = this.field_147009_r + this.drawablesY + i * this.drawablesOffset;
                if (x < posX || posX + 10 < x || y < posY || posY + 10 < y) continue;
                this.drawableClickCooldown.setZero();
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)DRAWABLE_CLICK_SOUND, (float)1.0f));
                Ulysses.NETWORK.sendToServer((IMessage)PacketInventoryWatch_ChangeGuiType.create(drawable.inventoryType));
                return;
            }
        }
        super.func_73864_a(x, y, buttonID);
    }

    public static void registerDrawable(String inventoryType, int inventoryTypeIndex, int atlasX, int atlasY) {
        buttonsRegistry.add(new IntegrationDrawableButton(inventoryType, inventoryTypeIndex, atlasX, atlasY));
        Collections.sort(buttonsRegistry);
    }
}

