/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.ulysses.common.network;

import by.fxg.ulysses.common.integration.IntegrationManager;
import by.fxg.ulysses.common.integration.IntegrationPart;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.Map;

public class PacketIntegrationSupported
implements IMessage {
    public void toBytes(ByteBuf buf) {
        Map<String, IntegrationPart> parts = IntegrationManager.INSTANCE.getIntegrations();
        buf.writeShort(parts.size());
        for (Map.Entry<String, IntegrationPart> entry : parts.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            buf.writeBoolean(entry.getValue().isSupportedByServer());
        }
    }

    public void fromBytes(ByteBuf buf) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            int size = buf.readShort();
            for (int i = 0; i != size; ++i) {
                String modID = ByteBufUtils.readUTF8String((ByteBuf)buf);
                boolean isSupported = buf.readBoolean();
                IntegrationPart part = IntegrationManager.INSTANCE.getIntegrationByID(modID);
                if (part == null) continue;
                part.setSupportedByServer(isSupported);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketIntegrationSupported, IMessage> {
        public IMessage onMessage(PacketIntegrationSupported message, MessageContext ctx) {
            return null;
        }
    }
}

