/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.ulysses.common.util;

import by.fxg.basicfml.util.IByteBufSerializable;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InventoryHistoryEntry
implements IByteBufSerializable,
Comparable<InventoryHistoryEntry> {
    public LocalDateTime timestamp;
    public String dimName;
    public int dimID;
    public String sourceType;
    public String sourceEntity;

    public InventoryHistoryEntry() {
    }

    public InventoryHistoryEntry(@Nonnull LocalDateTime localDateTime, @Nonnull String dimName, int dimID, @Nonnull String sourceType, @Nullable String sourceEntity) {
        this.timestamp = localDateTime;
        this.dimName = dimName;
        this.dimID = dimID;
        this.sourceType = sourceType;
        this.sourceEntity = sourceEntity;
    }

    public void writeToByteBuf(ByteBuf buf) {
        buf.writeShort(this.timestamp.getYear());
        buf.writeByte(this.timestamp.getMonthValue());
        buf.writeByte(this.timestamp.getDayOfMonth());
        buf.writeByte(this.timestamp.getHour());
        buf.writeByte(this.timestamp.getMinute());
        buf.writeByte(this.timestamp.getSecond());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.dimName);
        buf.writeInt(this.dimID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.sourceType);
        if (this.sourceEntity != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.sourceEntity);
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readFromByteBuf(ByteBuf buf) {
        this.timestamp = LocalDateTime.of((int)buf.readShort(), buf.readByte(), (int)buf.readByte(), (int)buf.readByte(), (int)buf.readByte(), (int)buf.readByte());
        this.dimName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.dimID = buf.readInt();
        this.sourceType = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.sourceEntity = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    @Override
    public int compareTo(InventoryHistoryEntry o) {
        return this.timestamp.isBefore(o.timestamp) ? -1 : (this.timestamp.isEqual(o.timestamp) ? 0 : 1);
    }
}

