/*
 * Decompiled with CFR 0.152.
 */
package com.arcaneware.unifier;

import com.arcaneware.unifier.config.Config;
import com.arcaneware.unifier.shared.SharedProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameData;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="Unifier", name="Unifier", version="1.12", dependencies="required-after:Forge@[10.13.2.1291,]", acceptedMinecraftVersions="[1.7.10]", acceptableRemoteVersions="*")
public class OreUnifier {
    @Mod.Instance
    public static OreUnifier instance;
    @SidedProxy(serverSide="com.arcaneware.unifier.server.ServerProxy", clientSide="com.arcaneware.unifier.client.ClientProxy")
    public static SharedProxy sharedProxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        sharedProxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        sharedProxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        sharedProxy.postInit(e);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent e) {
        sharedProxy.serverLoad(e);
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent e) {
        sharedProxy.serverStop(e);
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        sharedProxy.onItemToss(event);
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        sharedProxy.onItemPickup(event);
    }

    @SubscribeEvent
    public void inInventory(PlayerOpenContainerEvent event) {
        sharedProxy.inInventory(event);
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        sharedProxy.onLivingDrops(event);
    }

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        sharedProxy.onBlockHarvest(event);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        sharedProxy.onChunkLoad(event);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        sharedProxy.onWorldTick(event);
    }

    private static boolean oreIdAllowed(String id) {
        String[] disIds = Config.instance().disallowedIds;
        for (int i = 0; i < disIds.length; ++i) {
            if (!id.equals(disIds[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean oreNameAllowed(String oreName) {
        String[] disNames = Config.instance().disallowedNames;
        for (int i = 0; i < disNames.length; ++i) {
            if (!oreName.equals(disNames[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean orePrefixAllowed(String oreName) {
        String[] allowPref = Config.instance().allowedPrefixes;
        for (int i = 0; i < allowPref.length; ++i) {
            if (!oreName.startsWith(allowPref[i])) continue;
            return true;
        }
        return false;
    }

    public static ItemStack unifiedStack(ItemStack originStack, ItemStack destinationStack) {
        String itemName = GameData.getItemRegistry().func_148750_c((Object)destinationStack.func_77973_b());
        if (!OreUnifier.sameMod(originStack, destinationStack) && OreUnifier.oreIdAllowed(itemName)) {
            ItemStack copy = destinationStack.func_77946_l();
            copy.field_77994_a = originStack.field_77994_a;
            copy.field_77990_d = originStack.field_77990_d;
            return copy;
        }
        return originStack;
    }

    public static ItemStack unify(ItemStack par1ItemStack) {
        if (par1ItemStack == null || par1ItemStack.func_77973_b() == null) {
            return par1ItemStack;
        }
        String itemName = GameData.getItemRegistry().func_148750_c((Object)par1ItemStack.func_77973_b());
        try {
            if (!OreUnifier.oreIdAllowed(itemName)) {
                return par1ItemStack;
            }
            int[] oreIds = OreDictionary.getOreIDs((ItemStack)par1ItemStack);
            if (oreIds.length < 1) {
                return par1ItemStack;
            }
            int oreId = -1;
            for (int i = 0; i < oreIds.length; ++i) {
                String oreName = OreDictionary.getOreName((int)oreIds[i]);
                if (!OreUnifier.oreNameAllowed(oreName) || !OreUnifier.orePrefixAllowed(oreName) || oreId != -1) continue;
                oreId = oreIds[i];
            }
            if (oreId != -1) {
                CopyOnWriteArrayList oresIter = new CopyOnWriteArrayList(OreDictionary.getOres((String)OreDictionary.getOreName((int)oreId)));
                String[] priorityMods = Config.instance().priorityModIds;
                for (int i = 0; i < priorityMods.length; ++i) {
                    for (ItemStack stack : oresIter) {
                        String stackMod = OreUnifier.modName(stack);
                        if (stackMod == null || !stackMod.equalsIgnoreCase(priorityMods[i])) continue;
                        return OreUnifier.unifiedStack(par1ItemStack, stack);
                    }
                }
                if (oresIter.size() > 0) {
                    return OreUnifier.unifiedStack(par1ItemStack, (ItemStack)oresIter.get(0));
                }
                return par1ItemStack;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return par1ItemStack;
    }

    public static void condense(IInventory inv, int offset, ItemStack stack, int stackSlot) {
        if (inv != null && stack != null) {
            for (int i = offset; i < stackSlot; ++i) {
                int maxStack;
                ItemStack slotStack = inv.func_70301_a(i);
                if (slotStack == null || !slotStack.func_77969_a(stack) || slotStack.field_77994_a >= (maxStack = Math.max(inv.func_70297_j_(), stack.func_77976_d()))) continue;
                if (slotStack.field_77994_a + stack.field_77994_a > maxStack) {
                    stack.field_77994_a -= maxStack - slotStack.field_77994_a;
                    slotStack.field_77994_a = maxStack;
                } else if (slotStack.field_77994_a + stack.field_77994_a <= maxStack) {
                    slotStack.field_77994_a += stack.field_77994_a;
                    stack.field_77994_a = 0;
                }
                inv.func_70299_a(i, slotStack);
                inv.func_70299_a(stackSlot, (ItemStack)(stack.field_77994_a > 0 ? stack : null));
            }
        }
    }

    private static boolean sameMod(ItemStack originStack, ItemStack destinationStack) {
        String destMod = OreUnifier.modName(destinationStack);
        String originMod = OreUnifier.modName(originStack);
        return destMod != null && originMod != null && originMod.equalsIgnoreCase(destMod);
    }

    private static String modName(ItemStack stack) {
        String stackMod = GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b());
        if (stackMod != null) {
            stackMod = stackMod.substring(0, stackMod.indexOf(":"));
            return stackMod;
        }
        return null;
    }
}

