/*
 * Decompiled with CFR 0.152.
 */
package com.arcaneware.unifier.config;

import com.arcaneware.unifier.shared.info.Reference;
import cpw.mods.fml.common.Loader;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static Configuration config = null;
    private static File configFile = null;
    private static Config instance;
    public boolean onItemTossEnable;
    public boolean onItemPickupEnable;
    public boolean inPlayerInventoryEnable;
    public boolean inOtherInventoryEnable;
    public boolean onLivingDropsEnable;
    public boolean onBlockHarvestEnable;
    public boolean onChunkLoadEnable;
    public boolean inTileEntityEnable;
    public String[] allowedPrefixes;
    public String[] disallowedNames;
    public String[] disallowedIds;
    public String[] priorityModIds;

    private Config() {
        try {
            configFile = new File(Loader.instance().getConfigDir(), "Unifier.cfg");
            config = new Configuration(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Config instance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public void reload() {
        try {
            config.load();
            this.onItemTossEnable = config.getBoolean("onItemTossEnable", "unifier", true, "Enables unification when a player drops items.");
            this.onItemPickupEnable = config.getBoolean("onItemPickupEnable", "unifier", true, "Enables unification when items are picked up.");
            this.inPlayerInventoryEnable = config.getBoolean("inPlayerInventoryEnable", "unifier", true, "Enables unification in player inventory.");
            this.inOtherInventoryEnable = config.getBoolean("inOtherInventoryEnable", "unifier", true, "Enables unification in other inventories accessed by player. IE: Player opening a chest, now unifies contents of chest.");
            this.onLivingDropsEnable = config.getBoolean("onLivingDropsEnable", "unifier", true, "Enables unification on living entity drops. IE: player and mob deaths");
            this.onBlockHarvestEnable = config.getBoolean("onBlockHarvestEnable", "unifier", true, "Enables unification on block drops. IE: mining a block");
            this.onChunkLoadEnable = config.getBoolean("onChunkLoadEnable", "unifier", false, "Enables unification on chunk load. #WARNING#, can cause lag! Only enable to unify blocks in the world that have already been places/generated");
            this.inTileEntityEnable = config.getBoolean("inTileEntityEnable", "unifier", false, "Enables unification in tile entities (chests, etc) on world tick. #WARNING# Can possibly cause lag if lots of chests are around.");
            this.allowedPrefixes = config.getStringList("allowedPrefixes", "unifier", Reference.defaultAllowedPrefixes, "Allowed oreDictionary Prefixes");
            this.disallowedNames = config.getStringList("disallowedNames", "unifier", Reference.defaultDisallowedNames, "Disallowed oreDictionary names: Use f3+h in your client WITH THE MOD to see oreDict names");
            this.disallowedIds = config.getStringList("disallowedIds", "unifier", Reference.defaultDisallowedIds, "Disallowed item Ids: Use f3+h in your client to see item ids");
            this.priorityModIds = config.getStringList("priorityModIds", "unifier", Reference.defaultPriorityModIds, "Mods with priority high enough to be specified above");
            config.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

