/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import java.text.DecimalFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.blocks.machine.beta.TileBoilerTank;
import mods.railcraft.common.blocks.machine.beta.TileEngine;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteam;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import mods.railcraft.common.blocks.machine.beta.TileTankBase;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackElectric;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EntityLocomotiveElectric;
import mods.railcraft.common.carts.EntityLocomotiveSteam;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.items.ItemElectricMeter;
import mods.railcraft.common.plugins.buildcraft.triggers.ITemperature;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tterrag.wailaplugins.api.Plugin;
import tterrag.wailaplugins.config.WPConfigHandler;
import tterrag.wailaplugins.plugins.PluginBase;
import tterrag.wailaplugins.plugins.PluginIFluidHandler;

@Plugin(deps={"Railcraft"})
public class PluginRailcraft
extends PluginBase
implements IWailaEntityProvider {
    private static final DecimalFormat fmtCharge = new DecimalFormat("#.##");
    public static final String TANK_FLUID = "tankFluid";
    public static final String HEAT = "heat";
    public static final String MAX_HEAT = "maxHeat";
    public static final String CURRENT_OUTPUT = "currentOutput";
    public static final String ENERGY_STORED = "energyStored";
    public static final String CHARGE = "charge";

    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.registerBody(TileMachineBase.class, TileTrack.class);
        this.registerNBT(TileEngineSteam.class, IElectricGrid.class, TileTrack.class, TileMultiBlock.class);
        this.registerEntityBody(this, EntityLocomotive.class);
        this.registerEntityNBT(this, EntityLocomotive.class);
        this.addConfig("multiblocks");
        this.addConfig(HEAT);
        this.addConfig("tanks");
        this.addConfig("energy");
        this.addConfig("engines");
        this.addConfig(CHARGE);
        this.addConfig("locomotives");
    }

    @Override
    public void postLoad() {
        ModuleRegistrar.instance().bodyBlockProviders.remove(TileTankBase.class);
    }

    @Override
    protected void getBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
        TileEntity tile = accessor.getTileEntity();
        NBTTagCompound tag = accessor.getNBTData();
        if (tile instanceof TileMultiBlock && this.getConfig("multiblocks")) {
            currenttip.add(String.format(lang.localize("formed"), lang.localize(((TileMultiBlock)tile).isStructureValid() ? "yes" : "no")));
        }
        if ((tile instanceof TileEngineSteamHobby || tile instanceof TileBoilerFirebox || tile instanceof TileBoilerTank) && this.getConfig(HEAT)) {
            PluginRailcraft.addHeatTooltip(currenttip, tag);
        }
        if (tile instanceof TileEngine && this.getConfig("engines")) {
            int energy = tag.func_74762_e(ENERGY_STORED);
            int gen = Math.round(tag.func_74760_g(CURRENT_OUTPUT));
            currenttip.add(lang.localize(ENERGY_STORED, new Object[]{energy + " / " + ((TileEngine)tile).maxEnergy() + " RF"}));
            currenttip.add(lang.localize("generating", new Object[]{gen}));
        }
        if (tag.func_74764_b(TANK_FLUID)) {
            FluidTankInfo info = PluginIFluidHandler.readFluidInfoFromNBT(tag.func_74775_l(TANK_FLUID));
            PluginIFluidHandler.addTankTooltip(currenttip, info);
        }
        if (this.getConfig(CHARGE) && tag.func_74764_b(CHARGE)) {
            PluginRailcraft.addChargeTooltip(currenttip, tag, accessor.getPlayer());
        }
    }

    private static void addChargeTooltip(List<String> currenttip, NBTTagCompound tag, EntityPlayer player) {
        ItemStack current = player.func_71045_bC();
        boolean hasMeter = !WPConfigHandler.meterInHand || current != null && ItemUtil.stacksEqual((ItemStack)current, (ItemStack)ItemElectricMeter.getItem());
        double charge = tag.func_74769_h(CHARGE);
        String chargeFmt = fmtCharge.format(charge) + "c";
        currenttip.add(EnumChatFormatting.RESET + String.format(lang.localize(CHARGE), hasMeter ? chargeFmt : EnumChatFormatting.ITALIC + lang.localize("needMeter")));
    }

    private static void addHeatTooltip(List<String> currenttip, NBTTagCompound tag) {
        int heat = Math.round(tag.func_74760_g(HEAT));
        int max = Math.round(tag.func_74760_g(MAX_HEAT));
        currenttip.add(String.format(lang.localize("engineTemp"), heat, max));
    }

    @Override
    protected void getNBTData(TileEntity te, NBTTagCompound tag, World world, BlockCoord pos) {
        ITrackInstance track;
        if (te instanceof TileMultiBlock && ((TileMultiBlock)te).getMasterBlock() != null) {
            if (te instanceof TileTankBase && !(te instanceof IFluidHandler)) {
                te = ((TileMultiBlock)te).getMasterBlock();
                StandardTank tank = ((TileTankBase)te).getTank();
                NBTTagCompound fluidTag = new NBTTagCompound();
                PluginIFluidHandler.writeFluidInfoToNBT(tank.getInfo(), fluidTag);
                tag.func_74782_a(TANK_FLUID, (NBTBase)fluidTag);
            }
            te = ((TileMultiBlock)te).getMasterBlock();
        }
        if (te instanceof ITemperature) {
            tag.func_74776_a(HEAT, ((ITemperature)te).getTemperature());
        }
        if (te instanceof TileEngine) {
            tag.func_74776_a(CURRENT_OUTPUT, ((TileEngine)te).currentOutput);
            tag.func_74768_a(ENERGY_STORED, ((TileEngine)te).getEnergy());
            if (te instanceof TileEngineSteamHobby) {
                tag.func_74780_a(MAX_HEAT, ((TileEngineSteamHobby)te).boiler.getMaxHeat());
            }
        }
        if (te instanceof IElectricGrid) {
            tag.func_74780_a(CHARGE, ((IElectricGrid)te).getChargeHandler().getCharge());
        }
        if (te instanceof TileTrack && (track = ((TileTrack)te).getTrackInstance()) instanceof IElectricGrid) {
            tag.func_74780_a(CHARGE, ((TrackElectric)track).getChargeHandler().getCharge());
        }
    }

    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (!this.getConfig("locomotives")) {
            return currenttip;
        }
        if (entity instanceof EntityLocomotiveElectric) {
            PluginRailcraft.addChargeTooltip(currenttip, tag, accessor.getPlayer());
        }
        if (entity instanceof EntityLocomotiveSteam) {
            PluginRailcraft.addHeatTooltip(currenttip, tag);
        }
        return currenttip;
    }

    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
        if (ent instanceof EntityLocomotiveElectric) {
            tag.func_74780_a(CHARGE, ((EntityLocomotiveElectric)ent).getChargeHandler().getCharge());
        }
        if (ent instanceof EntityLocomotiveSteam) {
            tag.func_74780_a(HEAT, ((EntityLocomotiveSteam)ent).boiler.getHeat());
            tag.func_74780_a(MAX_HEAT, ((EntityLocomotiveSteam)ent).boiler.getMaxHeat());
        }
        return tag;
    }
}

