/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wailaevents.asm;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class ASMHelper {
    public static byte[] createByteArrayFromClass(ClassNode classNode, int flags) {
        ClassWriter classWriter = new ClassWriter(flags);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public static ClassNode createClassFromByteArray(byte[] classBytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classNode, 8);
        return classNode;
    }

    public static boolean hasClassMethodName(ClassNode classNode, String methodName) {
        for (MethodNode method : classNode.methods) {
            if (!methodName.equals(method.name)) continue;
            return true;
        }
        return false;
    }

    public static MethodNode getMethodFromClass(ClassNode classNode, String methodName, String descriptor) {
        for (MethodNode mnode : classNode.methods) {
            if (!methodName.equals(mnode.name) || !descriptor.equals(mnode.desc)) continue;
            return mnode;
        }
        throw new MethodNotFoundException(methodName, descriptor);
    }

    public static class MethodNotFoundException
    extends RuntimeException {
        public MethodNotFoundException(String methodName, String methodDesc) {
            super("Attempt to find a method has failed. Method: " + methodName + " Descriptor: " + methodDesc);
        }
    }
}

