/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wailaevents.asm;

import net.darkhax.wailaevents.asm.ASMHelper;
import net.darkhax.wailaevents.util.Constants;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class OverlayRendererTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] classBytes) {
        if (transformedName.equals("mcp.mobius.waila.overlay.OverlayRenderer")) {
            return this.transformOverlayRenderer(classBytes);
        }
        return classBytes;
    }

    private byte[] transformOverlayRenderer(byte[] bytes) {
        Constants.LOG.info("OverlayRenderer found. Preparing to inject new events, this will only hurt a little bit.");
        ClassNode classNode = ASMHelper.createClassFromByteArray(bytes);
        MethodNode methodNode = ASMHelper.getMethodFromClass(classNode, "renderOverlay", "()V");
        AbstractInsnNode startNode = null;
        AbstractInsnNode endNode = null;
        for (AbstractInsnNode insn : methodNode.instructions.toArray()) {
            if (startNode == null) {
                startNode = insn;
            }
            if (insn.getOpcode() != 177) continue;
            endNode = insn.getPrevious();
        }
        if (startNode != null) {
            methodNode.instructions.insert(startNode, OverlayRendererTransformer.getPreInstructions());
        }
        if (endNode != null) {
            methodNode.instructions.insertBefore(endNode, OverlayRendererTransformer.getPostInstructions());
        }
        Constants.LOG.info("Transformation complete, new events have been injected.");
        return ASMHelper.createByteArrayFromClass(classNode, 3);
    }

    private static InsnList getPreInstructions() {
        Constants.LOG.info("Injecting WailaRenderEvent.Pre");
        LabelNode start = new LabelNode();
        LabelNode end = new LabelNode();
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)start);
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, "net/darkhax/wailaevents/util/Utilities", "isSafeForTooltip", "()Z", false));
        instructions.add((AbstractInsnNode)new JumpInsnNode(153, end));
        instructions.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", "Lcpw/mods/fml/common/eventhandler/EventBus;"));
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, "net/darkhax/wailaevents/event/WailaRenderEvent$Pre"));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, "net/darkhax/wailaevents/event/WailaRenderEvent$Pre", "<init>", "()V", false));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "cpw/mods/fml/common/eventhandler/EventBus", "post", "(Lcpw/mods/fml/common/eventhandler/Event;)Z", false));
        instructions.add((AbstractInsnNode)new JumpInsnNode(153, end));
        instructions.add((AbstractInsnNode)new InsnNode(177));
        instructions.add((AbstractInsnNode)end);
        return instructions;
    }

    private static InsnList getPostInstructions() {
        Constants.LOG.info("Injecting WailaRenderEvent.Post");
        LabelNode start = new LabelNode();
        InsnList i = new InsnList();
        i.add((AbstractInsnNode)start);
        i.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", "Lcpw/mods/fml/common/eventhandler/EventBus;"));
        i.add((AbstractInsnNode)new TypeInsnNode(187, "net/darkhax/wailaevents/event/WailaRenderEvent$Post"));
        i.add((AbstractInsnNode)new InsnNode(89));
        i.add((AbstractInsnNode)new MethodInsnNode(183, "net/darkhax/wailaevents/event/WailaRenderEvent$Post", "<init>", "()V", false));
        i.add((AbstractInsnNode)new MethodInsnNode(182, "cpw/mods/fml/common/eventhandler/EventBus", "post", "(Lcpw/mods/fml/common/eventhandler/Event;)Z", false));
        i.add((AbstractInsnNode)new InsnNode(87));
        return i;
    }
}

