/*
 * Decompiled with CFR 0.152.
 */
package com.github.gunirs.anchors.blocks;

import com.github.gunirs.anchors.Anchors;
import com.github.gunirs.anchors.AnchorsTab;
import com.github.gunirs.anchors.tileentity.TileWorldAnchor;
import com.github.gunirs.anchors.utils.Logger;
import com.github.gunirs.anchors.utils.enums.LoadingMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockWorldAnchor
extends BlockContainer {
    public BlockWorldAnchor() {
        super(Material.field_151576_e);
        this.func_149663_c("anchors:blockWorldAnchor");
        this.func_149658_d("anchors:blockWorldAnchor");
        this.func_149711_c(2.0f);
        this.func_149647_a(AnchorsTab.mainTab);
        this.func_149715_a(1.0f);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileWorldAnchor();
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileWorldAnchor tileWorldAnchor;
        double xx = (float)x + random.nextFloat();
        double yy = (float)y + 1.8f;
        double zz = (float)z + random.nextFloat();
        double d3 = 0.0;
        double d4 = 2.0;
        double d5 = 0.0;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileWorldAnchor && ((tileWorldAnchor = (TileWorldAnchor)te).getChunkLoadingTime() > 0 || tileWorldAnchor.isAdminModeAnchor()) && !tileWorldAnchor.isPaused()) {
            world.func_72869_a("portal", xx, yy, zz, d3, d4, d5);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                TileEntity te = world.func_147438_o(x, y, z);
                if (te instanceof TileWorldAnchor) {
                    TileWorldAnchor tileWorldAnchor = (TileWorldAnchor)te;
                    boolean paused = tileWorldAnchor.isPaused();
                    if (paused && (tileWorldAnchor.getChunkLoadingTime() > 0 || tileWorldAnchor.isAdminModeAnchor())) {
                        tileWorldAnchor.forceChunkLoading();
                        tileWorldAnchor.setPaused(false);
                    } else {
                        tileWorldAnchor.releaseTicket();
                        tileWorldAnchor.setPaused(true);
                    }
                    world.func_147471_g(x, y, z);
                }
            } else {
                player.openGui((Object)Anchors.INSTANCE, 0, world, x, y, z);
            }
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack itemIn) {
        if (!world.field_72995_K) {
            System.out.println("[Anchors] Placed (" + x + ", " + y + ", " + z + ") world anchor by " + placer.func_70005_c_());
            try {
                Logger.log(LocalDateTime.now() + " | Placed (" + x + " " + y + " " + z + ") world anchor by " + placer.func_70005_c_());
                Logger.Active.add(placer.func_70005_c_(), x, y, z);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            NBTTagCompound nbtTagCompound = itemIn.func_77978_p();
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileWorldAnchor) {
                TileWorldAnchor tileWorldAnchor = (TileWorldAnchor)te;
                tileWorldAnchor.onBlockPlacedBy(placer);
                if (nbtTagCompound != null) {
                    int chunkLoadingTime = nbtTagCompound.func_74764_b("chunkLoadingTime") ? nbtTagCompound.func_74762_e("chunkLoadingTime") : 0;
                    LoadingMode mode = LoadingMode.fromInteger(nbtTagCompound.func_74764_b("mode") ? (int)nbtTagCompound.func_74765_d("mode") : 0);
                    tileWorldAnchor.setPaused(true);
                    tileWorldAnchor.setChunkLoadingTime(chunkLoadingTime);
                    tileWorldAnchor.setMode(mode);
                }
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockBroken, int meta) {
        if (!world.field_72995_K) {
            System.out.println("[Anchors] Broken (" + x + " " + y + " " + z + ") world anchor");
            try {
                Logger.log(LocalDateTime.now() + " | Broken (" + x + " " + y + " " + z + ") world anchor");
                Logger.Active.remove(x, y, z);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileWorldAnchor) {
                TileWorldAnchor tileWorldAnchor = (TileWorldAnchor)te;
                Random rand = new Random();
                float randX = rand.nextFloat() * 0.8f + 0.1f;
                float randY = rand.nextFloat() * 0.8f + 0.1f;
                float randZ = rand.nextFloat() * 0.8f + 0.1f;
                ItemStack item = new ItemStack(Item.func_150898_a((Block)this), 1, 0);
                EntityItem entityItem = new EntityItem(world, (double)((float)x + randX), (double)((float)y + randY), (double)((float)z + randZ), item.func_77946_l());
                int time = tileWorldAnchor.getChunkLoadingTime();
                LoadingMode mode = tileWorldAnchor.getMode();
                ItemStack itemStackInFirstSlot = tileWorldAnchor.getFuelSlotItem();
                if (time != 0) {
                    NBTTagCompound tagCompound = entityItem.func_92059_d().func_77978_p();
                    if (tagCompound == null) {
                        tagCompound = new NBTTagCompound();
                    }
                    tagCompound.func_74768_a("chunkLoadingTime", time);
                    tagCompound.func_74777_a("mode", (short)mode.ordinal());
                    entityItem.func_92059_d().func_77982_d(tagCompound);
                }
                float factor = 0.05f;
                entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
                entityItem.field_70181_x = 0.0;
                entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
                if (itemStackInFirstSlot != null) {
                    EntityItem entityFuelItem = new EntityItem(world, (double)((float)x + randX), (double)((float)y + randY), (double)((float)z + randZ), itemStackInFirstSlot);
                    entityFuelItem.field_70159_w = entityItem.field_70159_w;
                    entityFuelItem.field_70181_x = 0.0;
                    entityFuelItem.field_70179_y = entityItem.field_70179_y;
                    world.func_72838_d((Entity)entityFuelItem);
                }
                world.func_72838_d((Entity)entityItem);
            }
        }
        super.func_149749_a(world, x, y, z, blockBroken, meta);
    }

    public Item func_149694_d(World worldIn, int x, int y, int z) {
        return Item.func_150898_a((Block)this);
    }
}

